/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkflowRequest extends MwaaServerlessRequest implements
        ToCopyableBuilder<UpdateWorkflowRequest.Builder, UpdateWorkflowRequest> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowArn").getter(getter(UpdateWorkflowRequest::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()).build();

    private static final SdkField<DefinitionS3Location> DEFINITION_S3_LOCATION_FIELD = SdkField
            .<DefinitionS3Location> builder(MarshallingType.SDK_POJO).memberName("DefinitionS3Location")
            .getter(getter(UpdateWorkflowRequest::definitionS3Location)).setter(setter(Builder::definitionS3Location))
            .constructor(DefinitionS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionS3Location").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateWorkflowRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateWorkflowRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(UpdateWorkflowRequest::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<Integer> ENGINE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EngineVersion").getter(getter(UpdateWorkflowRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("NetworkConfiguration")
            .getter(getter(UpdateWorkflowRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build())
            .build();

    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TriggerMode").getter(getter(UpdateWorkflowRequest::triggerMode)).setter(setter(Builder::triggerMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD,
            DEFINITION_S3_LOCATION_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD, LOGGING_CONFIGURATION_FIELD, ENGINE_VERSION_FIELD,
            NETWORK_CONFIGURATION_FIELD, TRIGGER_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowArn;

    private final DefinitionS3Location definitionS3Location;

    private final String roleArn;

    private final String description;

    private final LoggingConfiguration loggingConfiguration;

    private final Integer engineVersion;

    private final NetworkConfiguration networkConfiguration;

    private final String triggerMode;

    private UpdateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.definitionS3Location = builder.definitionS3Location;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.engineVersion = builder.engineVersion;
        this.networkConfiguration = builder.networkConfiguration;
        this.triggerMode = builder.triggerMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow you want to update.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The Amazon S3 location where the updated workflow definition file is stored.
     * </p>
     * 
     * @return The Amazon S3 location where the updated workflow definition file is stored.
     */
    public final DefinitionS3Location definitionS3Location() {
        return definitionS3Location;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon Managed Workflows for Apache Airflow Serverless
     * assumes when it executes the updated workflow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that Amazon Managed Workflows for Apache Airflow
     *         Serverless assumes when it executes the updated workflow.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An updated description for the workflow.
     * </p>
     * 
     * @return An updated description for the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Updated logging configuration for the workflow.
     * </p>
     * 
     * @return Updated logging configuration for the workflow.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * <p>
     * The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that you want to use for the
     * updated workflow.
     * </p>
     * 
     * @return The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that you want to use for
     *         the updated workflow.
     */
    public final Integer engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Updated network configuration for the workflow execution environment.
     * </p>
     * 
     * @return Updated network configuration for the workflow execution environment.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The trigger mode for the workflow execution.
     * </p>
     * 
     * @return The trigger mode for the workflow execution.
     */
    public final String triggerMode() {
        return triggerMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(definitionS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(triggerMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowRequest)) {
            return false;
        }
        UpdateWorkflowRequest other = (UpdateWorkflowRequest) obj;
        return Objects.equals(workflowArn(), other.workflowArn())
                && Objects.equals(definitionS3Location(), other.definitionS3Location())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(description(), other.description())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(triggerMode(), other.triggerMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkflowRequest").add("WorkflowArn", workflowArn())
                .add("DefinitionS3Location", definitionS3Location()).add("RoleArn", roleArn()).add("Description", description())
                .add("LoggingConfiguration", loggingConfiguration()).add("EngineVersion", engineVersion())
                .add("NetworkConfiguration", networkConfiguration()).add("TriggerMode", triggerMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "DefinitionS3Location":
            return Optional.ofNullable(clazz.cast(definitionS3Location()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "NetworkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "TriggerMode":
            return Optional.ofNullable(clazz.cast(triggerMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("DefinitionS3Location", DEFINITION_S3_LOCATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("TriggerMode", TRIGGER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkflowRequest, T> g) {
        return obj -> g.apply((UpdateWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkflowRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow you want to update.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the workflow you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The Amazon S3 location where the updated workflow definition file is stored.
         * </p>
         * 
         * @param definitionS3Location
         *        The Amazon S3 location where the updated workflow definition file is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionS3Location(DefinitionS3Location definitionS3Location);

        /**
         * <p>
         * The Amazon S3 location where the updated workflow definition file is stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefinitionS3Location.Builder} avoiding
         * the need to create one manually via {@link DefinitionS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefinitionS3Location.Builder#build()} is called immediately and
         * its result is passed to {@link #definitionS3Location(DefinitionS3Location)}.
         * 
         * @param definitionS3Location
         *        a consumer that will call methods on {@link DefinitionS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definitionS3Location(DefinitionS3Location)
         */
        default Builder definitionS3Location(Consumer<DefinitionS3Location.Builder> definitionS3Location) {
            return definitionS3Location(DefinitionS3Location.builder().applyMutation(definitionS3Location).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that Amazon Managed Workflows for Apache Airflow Serverless
         * assumes when it executes the updated workflow.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that Amazon Managed Workflows for Apache Airflow
         *        Serverless assumes when it executes the updated workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An updated description for the workflow.
         * </p>
         * 
         * @param description
         *        An updated description for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Updated logging configuration for the workflow.
         * </p>
         * 
         * @param loggingConfiguration
         *        Updated logging configuration for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * <p>
         * Updated logging configuration for the workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * <p>
         * The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that you want to use for the
         * updated workflow.
         * </p>
         * 
         * @param engineVersion
         *        The version of the Amazon Managed Workflows for Apache Airflow Serverless engine that you want to use
         *        for the updated workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(Integer engineVersion);

        /**
         * <p>
         * Updated network configuration for the workflow execution environment.
         * </p>
         * 
         * @param networkConfiguration
         *        Updated network configuration for the workflow execution environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * Updated network configuration for the workflow execution environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The trigger mode for the workflow execution.
         * </p>
         * 
         * @param triggerMode
         *        The trigger mode for the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerMode(String triggerMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MwaaServerlessRequest.BuilderImpl implements Builder {
        private String workflowArn;

        private DefinitionS3Location definitionS3Location;

        private String roleArn;

        private String description;

        private LoggingConfiguration loggingConfiguration;

        private Integer engineVersion;

        private NetworkConfiguration networkConfiguration;

        private String triggerMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkflowRequest model) {
            super(model);
            workflowArn(model.workflowArn);
            definitionS3Location(model.definitionS3Location);
            roleArn(model.roleArn);
            description(model.description);
            loggingConfiguration(model.loggingConfiguration);
            engineVersion(model.engineVersion);
            networkConfiguration(model.networkConfiguration);
            triggerMode(model.triggerMode);
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final DefinitionS3Location.Builder getDefinitionS3Location() {
            return definitionS3Location != null ? definitionS3Location.toBuilder() : null;
        }

        public final void setDefinitionS3Location(DefinitionS3Location.BuilderImpl definitionS3Location) {
            this.definitionS3Location = definitionS3Location != null ? definitionS3Location.build() : null;
        }

        @Override
        public final Builder definitionS3Location(DefinitionS3Location definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final Integer getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(Integer engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(Integer engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getTriggerMode() {
            return triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkflowRequest build() {
            return new UpdateWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
