/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration to use to schedule automated workflow execution using cron expressions. Amazon Managed Workflows
 * for Apache Airflow Serverless integrates with EventBridge Scheduler to provide cost-effective, timezone-aware
 * scheduling capabilities. The service supports both time-based and event-based scheduling (event-based scheduling
 * available post-GA). When a workflow definition includes scheduling information, Amazon Managed Workflows for Apache
 * Airflow Serverless automatically configures the appropriate triggers and ensures only one version of a workflow has
 * an active schedule at any time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleConfiguration.Builder, ScheduleConfiguration> {
    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CronExpression").getter(getter(ScheduleConfiguration::cronExpression))
            .setter(setter(Builder::cronExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRON_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cronExpression;

    private ScheduleConfiguration(BuilderImpl builder) {
        this.cronExpression = builder.cronExpression;
    }

    /**
     * <p>
     * A cron expression that defines when the workflow is automatically executed. Uses standard cron syntax.
     * </p>
     * 
     * @return A cron expression that defines when the workflow is automatically executed. Uses standard cron syntax.
     */
    public final String cronExpression() {
        return cronExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cronExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleConfiguration)) {
            return false;
        }
        ScheduleConfiguration other = (ScheduleConfiguration) obj;
        return Objects.equals(cronExpression(), other.cronExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleConfiguration").add("CronExpression", cronExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CronExpression":
            return Optional.ofNullable(clazz.cast(cronExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CronExpression", CRON_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduleConfiguration, T> g) {
        return obj -> g.apply((ScheduleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleConfiguration> {
        /**
         * <p>
         * A cron expression that defines when the workflow is automatically executed. Uses standard cron syntax.
         * </p>
         * 
         * @param cronExpression
         *        A cron expression that defines when the workflow is automatically executed. Uses standard cron syntax.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cronExpression(String cronExpression);
    }

    static final class BuilderImpl implements Builder {
        private String cronExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleConfiguration model) {
            cronExpression(model.cronExpression);
        }

        public final String getCronExpression() {
            return cronExpression;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        @Override
        public ScheduleConfiguration build() {
            return new ScheduleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
