/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowRunResponse extends MwaaServerlessResponse implements
        ToCopyableBuilder<GetWorkflowRunResponse.Builder, GetWorkflowRunResponse> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowArn").getter(getter(GetWorkflowRunResponse::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()).build();

    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowVersion").getter(getter(GetWorkflowRunResponse::workflowVersion))
            .setter(setter(Builder::workflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(GetWorkflowRunResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<String> RUN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RunType").getter(getter(GetWorkflowRunResponse::runTypeAsString)).setter(setter(Builder::runType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunType").build()).build();

    private static final SdkField<Map<String, Document>> OVERRIDE_PARAMETERS_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("OverrideParameters")
            .getter(getter(GetWorkflowRunResponse::overrideParameters))
            .setter(setter(Builder::overrideParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<WorkflowRunDetail> RUN_DETAIL_FIELD = SdkField
            .<WorkflowRunDetail> builder(MarshallingType.SDK_POJO).memberName("RunDetail")
            .getter(getter(GetWorkflowRunResponse::runDetail)).setter(setter(Builder::runDetail))
            .constructor(WorkflowRunDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD,
            WORKFLOW_VERSION_FIELD, RUN_ID_FIELD, RUN_TYPE_FIELD, OVERRIDE_PARAMETERS_FIELD, RUN_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowArn;

    private final String workflowVersion;

    private final String runId;

    private final String runType;

    private final Map<String, Document> overrideParameters;

    private final WorkflowRunDetail runDetail;

    private GetWorkflowRunResponse(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.workflowVersion = builder.workflowVersion;
        this.runId = builder.runId;
        this.runType = builder.runType;
        this.overrideParameters = builder.overrideParameters;
        this.runDetail = builder.runDetail;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workflow that contains this run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workflow that contains this run.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The version of the workflow that is used for this run.
     * </p>
     * 
     * @return The version of the workflow that is used for this run.
     */
    public final String workflowVersion() {
        return workflowVersion;
    }

    /**
     * <p>
     * The unique identifier of this workflow run.
     * </p>
     * 
     * @return The unique identifier of this workflow run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The type of workflow run. Values are <code>ON_DEMAND</code> (manually triggered) or <code>SCHEDULED</code>
     * (automatically triggered by schedule).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runType} will
     * return {@link RunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runTypeAsString}.
     * </p>
     * 
     * @return The type of workflow run. Values are <code>ON_DEMAND</code> (manually triggered) or
     *         <code>SCHEDULED</code> (automatically triggered by schedule).
     * @see RunType
     */
    public final RunType runType() {
        return RunType.fromValue(runType);
    }

    /**
     * <p>
     * The type of workflow run. Values are <code>ON_DEMAND</code> (manually triggered) or <code>SCHEDULED</code>
     * (automatically triggered by schedule).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runType} will
     * return {@link RunType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runTypeAsString}.
     * </p>
     * 
     * @return The type of workflow run. Values are <code>ON_DEMAND</code> (manually triggered) or
     *         <code>SCHEDULED</code> (automatically triggered by schedule).
     * @see RunType
     */
    public final String runTypeAsString() {
        return runType;
    }

    /**
     * For responses, this returns true if the service returned a value for the OverrideParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOverrideParameters() {
        return overrideParameters != null && !(overrideParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Parameters that were overridden for this specific workflow run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrideParameters} method.
     * </p>
     * 
     * @return Parameters that were overridden for this specific workflow run.
     */
    public final Map<String, Document> overrideParameters() {
        return overrideParameters;
    }

    /**
     * <p>
     * Detailed information about the workflow run execution, including timing, status, and task instances.
     * </p>
     * 
     * @return Detailed information about the workflow run execution, including timing, status, and task instances.
     */
    public final WorkflowRunDetail runDetail() {
        return runDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(runTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrideParameters() ? overrideParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(runDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRunResponse)) {
            return false;
        }
        GetWorkflowRunResponse other = (GetWorkflowRunResponse) obj;
        return Objects.equals(workflowArn(), other.workflowArn()) && Objects.equals(workflowVersion(), other.workflowVersion())
                && Objects.equals(runId(), other.runId()) && Objects.equals(runTypeAsString(), other.runTypeAsString())
                && hasOverrideParameters() == other.hasOverrideParameters()
                && Objects.equals(overrideParameters(), other.overrideParameters())
                && Objects.equals(runDetail(), other.runDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowRunResponse").add("WorkflowArn", workflowArn())
                .add("WorkflowVersion", workflowVersion()).add("RunId", runId()).add("RunType", runTypeAsString())
                .add("OverrideParameters", overrideParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RunDetail", runDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "WorkflowVersion":
            return Optional.ofNullable(clazz.cast(workflowVersion()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "RunType":
            return Optional.ofNullable(clazz.cast(runTypeAsString()));
        case "OverrideParameters":
            return Optional.ofNullable(clazz.cast(overrideParameters()));
        case "RunDetail":
            return Optional.ofNullable(clazz.cast(runDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        map.put("RunType", RUN_TYPE_FIELD);
        map.put("OverrideParameters", OVERRIDE_PARAMETERS_FIELD);
        map.put("RunDetail", RUN_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRunResponse, T> g) {
        return obj -> g.apply((GetWorkflowRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowRunResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workflow that contains this run.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the workflow that contains this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The version of the workflow that is used for this run.
         * </p>
         * 
         * @param workflowVersion
         *        The version of the workflow that is used for this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersion(String workflowVersion);

        /**
         * <p>
         * The unique identifier of this workflow run.
         * </p>
         * 
         * @param runId
         *        The unique identifier of this workflow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The type of workflow run. Values are <code>ON_DEMAND</code> (manually triggered) or <code>SCHEDULED</code>
         * (automatically triggered by schedule).
         * </p>
         * 
         * @param runType
         *        The type of workflow run. Values are <code>ON_DEMAND</code> (manually triggered) or
         *        <code>SCHEDULED</code> (automatically triggered by schedule).
         * @see RunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunType
         */
        Builder runType(String runType);

        /**
         * <p>
         * The type of workflow run. Values are <code>ON_DEMAND</code> (manually triggered) or <code>SCHEDULED</code>
         * (automatically triggered by schedule).
         * </p>
         * 
         * @param runType
         *        The type of workflow run. Values are <code>ON_DEMAND</code> (manually triggered) or
         *        <code>SCHEDULED</code> (automatically triggered by schedule).
         * @see RunType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunType
         */
        Builder runType(RunType runType);

        /**
         * <p>
         * Parameters that were overridden for this specific workflow run.
         * </p>
         * 
         * @param overrideParameters
         *        Parameters that were overridden for this specific workflow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideParameters(Map<String, Document> overrideParameters);

        /**
         * <p>
         * Detailed information about the workflow run execution, including timing, status, and task instances.
         * </p>
         * 
         * @param runDetail
         *        Detailed information about the workflow run execution, including timing, status, and task instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runDetail(WorkflowRunDetail runDetail);

        /**
         * <p>
         * Detailed information about the workflow run execution, including timing, status, and task instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowRunDetail.Builder} avoiding the
         * need to create one manually via {@link WorkflowRunDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowRunDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #runDetail(WorkflowRunDetail)}.
         * 
         * @param runDetail
         *        a consumer that will call methods on {@link WorkflowRunDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runDetail(WorkflowRunDetail)
         */
        default Builder runDetail(Consumer<WorkflowRunDetail.Builder> runDetail) {
            return runDetail(WorkflowRunDetail.builder().applyMutation(runDetail).build());
        }
    }

    static final class BuilderImpl extends MwaaServerlessResponse.BuilderImpl implements Builder {
        private String workflowArn;

        private String workflowVersion;

        private String runId;

        private String runType;

        private Map<String, Document> overrideParameters = DefaultSdkAutoConstructMap.getInstance();

        private WorkflowRunDetail runDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRunResponse model) {
            super(model);
            workflowArn(model.workflowArn);
            workflowVersion(model.workflowVersion);
            runId(model.runId);
            runType(model.runType);
            overrideParameters(model.overrideParameters);
            runDetail(model.runDetail);
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowVersion() {
            return workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getRunType() {
            return runType;
        }

        public final void setRunType(String runType) {
            this.runType = runType;
        }

        @Override
        public final Builder runType(String runType) {
            this.runType = runType;
            return this;
        }

        @Override
        public final Builder runType(RunType runType) {
            this.runType(runType == null ? null : runType.toString());
            return this;
        }

        public final Map<String, Document> getOverrideParameters() {
            if (overrideParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return overrideParameters;
        }

        public final void setOverrideParameters(Map<String, Document> overrideParameters) {
            this.overrideParameters = ObjectMapCopier.copy(overrideParameters);
        }

        @Override
        public final Builder overrideParameters(Map<String, Document> overrideParameters) {
            this.overrideParameters = ObjectMapCopier.copy(overrideParameters);
            return this;
        }

        public final WorkflowRunDetail.Builder getRunDetail() {
            return runDetail != null ? runDetail.toBuilder() : null;
        }

        public final void setRunDetail(WorkflowRunDetail.BuilderImpl runDetail) {
            this.runDetail = runDetail != null ? runDetail.build() : null;
        }

        @Override
        public final Builder runDetail(WorkflowRunDetail runDetail) {
            this.runDetail = runDetail;
            return this;
        }

        @Override
        public GetWorkflowRunResponse build() {
            return new GetWorkflowRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
