/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mwaaserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkflowResponse extends MwaaServerlessResponse implements
        ToCopyableBuilder<CreateWorkflowResponse.Builder, CreateWorkflowResponse> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowArn").getter(getter(CreateWorkflowResponse::workflowArn)).setter(setter(Builder::workflowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(CreateWorkflowResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(CreateWorkflowResponse::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final SdkField<String> WORKFLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowStatus").getter(getter(CreateWorkflowResponse::workflowStatusAsString))
            .setter(setter(Builder::workflowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowStatus").build()).build();

    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowVersion").getter(getter(CreateWorkflowResponse::workflowVersion))
            .setter(setter(Builder::workflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()).build();

    private static final SdkField<Boolean> IS_LATEST_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsLatestVersion").getter(getter(CreateWorkflowResponse::isLatestVersion))
            .setter(setter(Builder::isLatestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLatestVersion").build()).build();

    private static final SdkField<List<String>> WARNINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Warnings")
            .getter(getter(CreateWorkflowResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD,
            CREATED_AT_FIELD, REVISION_ID_FIELD, WORKFLOW_STATUS_FIELD, WORKFLOW_VERSION_FIELD, IS_LATEST_VERSION_FIELD,
            WARNINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowArn;

    private final Instant createdAt;

    private final String revisionId;

    private final String workflowStatus;

    private final String workflowVersion;

    private final Boolean isLatestVersion;

    private final List<String> warnings;

    private CreateWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.createdAt = builder.createdAt;
        this.revisionId = builder.revisionId;
        this.workflowStatus = builder.workflowStatus;
        this.workflowVersion = builder.workflowVersion;
        this.isLatestVersion = builder.isLatestVersion;
        this.warnings = builder.warnings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the newly created workflow. This ARN uniquely identifies the workflow resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the newly created workflow. This ARN uniquely identifies the workflow
     *         resource.
     */
    public final String workflowArn() {
        return workflowArn;
    }

    /**
     * <p>
     * The timestamp when the workflow was created, in ISO 8601 date-time format.
     * </p>
     * 
     * @return The timestamp when the workflow was created, in ISO 8601 date-time format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A unique identifier for this revision of the workflow configuration. This ID changes when the workflow is updated
     * and you can use it for optimistic concurrency control in update operations. The revision ID helps prevent
     * conflicting updates and ensures that updates are applied to the expected version of the workflow configuration.
     * </p>
     * 
     * @return A unique identifier for this revision of the workflow configuration. This ID changes when the workflow is
     *         updated and you can use it for optimistic concurrency control in update operations. The revision ID helps
     *         prevent conflicting updates and ensures that updates are applied to the expected version of the workflow
     *         configuration.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The current status of the workflow. Possible values are <code>READY</code> (workflow is ready to run) and
     * <code>DELETING</code> (workflow is being deleted).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowStatus}
     * will return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #workflowStatusAsString}.
     * </p>
     * 
     * @return The current status of the workflow. Possible values are <code>READY</code> (workflow is ready to run) and
     *         <code>DELETING</code> (workflow is being deleted).
     * @see WorkflowStatus
     */
    public final WorkflowStatus workflowStatus() {
        return WorkflowStatus.fromValue(workflowStatus);
    }

    /**
     * <p>
     * The current status of the workflow. Possible values are <code>READY</code> (workflow is ready to run) and
     * <code>DELETING</code> (workflow is being deleted).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowStatus}
     * will return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #workflowStatusAsString}.
     * </p>
     * 
     * @return The current status of the workflow. Possible values are <code>READY</code> (workflow is ready to run) and
     *         <code>DELETING</code> (workflow is being deleted).
     * @see WorkflowStatus
     */
    public final String workflowStatusAsString() {
        return workflowStatus;
    }

    /**
     * <p>
     * The version identifier of the workflow. This is a service-generated alphanumeric string that uniquely identifies
     * this version of the workflow. Amazon Managed Workflows for Apache Airflow Serverless uses a version-first
     * approach where each workflow can have multiple immutable versions, which allows you to maintain different
     * configurations and roll back to previous versions as needed. The version identifier is used in ARNs and API
     * operations to reference specific workflow versions.
     * </p>
     * 
     * @return The version identifier of the workflow. This is a service-generated alphanumeric string that uniquely
     *         identifies this version of the workflow. Amazon Managed Workflows for Apache Airflow Serverless uses a
     *         version-first approach where each workflow can have multiple immutable versions, which allows you to
     *         maintain different configurations and roll back to previous versions as needed. The version identifier is
     *         used in ARNs and API operations to reference specific workflow versions.
     */
    public final String workflowVersion() {
        return workflowVersion;
    }

    /**
     * <p>
     * A Boolean flag that indicates whether this workflow version is the latest version of the workflow.
     * </p>
     * 
     * @return A Boolean flag that indicates whether this workflow version is the latest version of the workflow.
     */
    public final Boolean isLatestVersion() {
        return isLatestVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Warnings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Warning messages generated during workflow creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWarnings} method.
     * </p>
     * 
     * @return Warning messages generated during workflow creation.
     */
    public final List<String> warnings() {
        return warnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(isLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowResponse)) {
            return false;
        }
        CreateWorkflowResponse other = (CreateWorkflowResponse) obj;
        return Objects.equals(workflowArn(), other.workflowArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(workflowStatusAsString(), other.workflowStatusAsString())
                && Objects.equals(workflowVersion(), other.workflowVersion())
                && Objects.equals(isLatestVersion(), other.isLatestVersion()) && hasWarnings() == other.hasWarnings()
                && Objects.equals(warnings(), other.warnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkflowResponse").add("WorkflowArn", workflowArn()).add("CreatedAt", createdAt())
                .add("RevisionId", revisionId()).add("WorkflowStatus", workflowStatusAsString())
                .add("WorkflowVersion", workflowVersion()).add("IsLatestVersion", isLatestVersion())
                .add("Warnings", hasWarnings() ? warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowArn":
            return Optional.ofNullable(clazz.cast(workflowArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "WorkflowStatus":
            return Optional.ofNullable(clazz.cast(workflowStatusAsString()));
        case "WorkflowVersion":
            return Optional.ofNullable(clazz.cast(workflowVersion()));
        case "IsLatestVersion":
            return Optional.ofNullable(clazz.cast(isLatestVersion()));
        case "Warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("RevisionId", REVISION_ID_FIELD);
        map.put("WorkflowStatus", WORKFLOW_STATUS_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("IsLatestVersion", IS_LATEST_VERSION_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowResponse, T> g) {
        return obj -> g.apply((CreateWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MwaaServerlessResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkflowResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the newly created workflow. This ARN uniquely identifies the workflow
         * resource.
         * </p>
         * 
         * @param workflowArn
         *        The Amazon Resource Name (ARN) of the newly created workflow. This ARN uniquely identifies the
         *        workflow resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowArn(String workflowArn);

        /**
         * <p>
         * The timestamp when the workflow was created, in ISO 8601 date-time format.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the workflow was created, in ISO 8601 date-time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A unique identifier for this revision of the workflow configuration. This ID changes when the workflow is
         * updated and you can use it for optimistic concurrency control in update operations. The revision ID helps
         * prevent conflicting updates and ensures that updates are applied to the expected version of the workflow
         * configuration.
         * </p>
         * 
         * @param revisionId
         *        A unique identifier for this revision of the workflow configuration. This ID changes when the workflow
         *        is updated and you can use it for optimistic concurrency control in update operations. The revision ID
         *        helps prevent conflicting updates and ensures that updates are applied to the expected version of the
         *        workflow configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The current status of the workflow. Possible values are <code>READY</code> (workflow is ready to run) and
         * <code>DELETING</code> (workflow is being deleted).
         * </p>
         * 
         * @param workflowStatus
         *        The current status of the workflow. Possible values are <code>READY</code> (workflow is ready to run)
         *        and <code>DELETING</code> (workflow is being deleted).
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder workflowStatus(String workflowStatus);

        /**
         * <p>
         * The current status of the workflow. Possible values are <code>READY</code> (workflow is ready to run) and
         * <code>DELETING</code> (workflow is being deleted).
         * </p>
         * 
         * @param workflowStatus
         *        The current status of the workflow. Possible values are <code>READY</code> (workflow is ready to run)
         *        and <code>DELETING</code> (workflow is being deleted).
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder workflowStatus(WorkflowStatus workflowStatus);

        /**
         * <p>
         * The version identifier of the workflow. This is a service-generated alphanumeric string that uniquely
         * identifies this version of the workflow. Amazon Managed Workflows for Apache Airflow Serverless uses a
         * version-first approach where each workflow can have multiple immutable versions, which allows you to maintain
         * different configurations and roll back to previous versions as needed. The version identifier is used in ARNs
         * and API operations to reference specific workflow versions.
         * </p>
         * 
         * @param workflowVersion
         *        The version identifier of the workflow. This is a service-generated alphanumeric string that uniquely
         *        identifies this version of the workflow. Amazon Managed Workflows for Apache Airflow Serverless uses a
         *        version-first approach where each workflow can have multiple immutable versions, which allows you to
         *        maintain different configurations and roll back to previous versions as needed. The version identifier
         *        is used in ARNs and API operations to reference specific workflow versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowVersion(String workflowVersion);

        /**
         * <p>
         * A Boolean flag that indicates whether this workflow version is the latest version of the workflow.
         * </p>
         * 
         * @param isLatestVersion
         *        A Boolean flag that indicates whether this workflow version is the latest version of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLatestVersion(Boolean isLatestVersion);

        /**
         * <p>
         * Warning messages generated during workflow creation.
         * </p>
         * 
         * @param warnings
         *        Warning messages generated during workflow creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<String> warnings);

        /**
         * <p>
         * Warning messages generated during workflow creation.
         * </p>
         * 
         * @param warnings
         *        Warning messages generated during workflow creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(String... warnings);
    }

    static final class BuilderImpl extends MwaaServerlessResponse.BuilderImpl implements Builder {
        private String workflowArn;

        private Instant createdAt;

        private String revisionId;

        private String workflowStatus;

        private String workflowVersion;

        private Boolean isLatestVersion;

        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowResponse model) {
            super(model);
            workflowArn(model.workflowArn);
            createdAt(model.createdAt);
            revisionId(model.revisionId);
            workflowStatus(model.workflowStatus);
            workflowVersion(model.workflowVersion);
            isLatestVersion(model.isLatestVersion);
            warnings(model.warnings);
        }

        public final String getWorkflowArn() {
            return workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getWorkflowStatus() {
            return workflowStatus;
        }

        public final void setWorkflowStatus(String workflowStatus) {
            this.workflowStatus = workflowStatus;
        }

        @Override
        public final Builder workflowStatus(String workflowStatus) {
            this.workflowStatus = workflowStatus;
            return this;
        }

        @Override
        public final Builder workflowStatus(WorkflowStatus workflowStatus) {
            this.workflowStatus(workflowStatus == null ? null : workflowStatus.toString());
            return this;
        }

        public final String getWorkflowVersion() {
            return workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final Boolean getIsLatestVersion() {
            return isLatestVersion;
        }

        public final void setIsLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
        }

        @Override
        public final Builder isLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
            return this;
        }

        public final Collection<String> getWarnings() {
            if (warnings instanceof SdkAutoConstructList) {
                return null;
            }
            return warnings;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = WarningMessagesCopier.copy(warnings);
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = WarningMessagesCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        public CreateWorkflowResponse build() {
            return new CreateWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
