/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaa.model.MwaaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCliTokenResponse
extends MwaaResponse
implements ToCopyableBuilder<Builder, CreateCliTokenResponse> {
    private static final SdkField<String> CLI_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CliToken").getter(CreateCliTokenResponse.getter(CreateCliTokenResponse::cliToken)).setter(CreateCliTokenResponse.setter(Builder::cliToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CliToken").build()}).build();
    private static final SdkField<String> WEB_SERVER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebServerHostname").getter(CreateCliTokenResponse.getter(CreateCliTokenResponse::webServerHostname)).setter(CreateCliTokenResponse.setter(Builder::webServerHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebServerHostname").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLI_TOKEN_FIELD, WEB_SERVER_HOSTNAME_FIELD));
    private final String cliToken;
    private final String webServerHostname;

    private CreateCliTokenResponse(BuilderImpl builder) {
        super(builder);
        this.cliToken = builder.cliToken;
        this.webServerHostname = builder.webServerHostname;
    }

    public final String cliToken() {
        return this.cliToken;
    }

    public final String webServerHostname() {
        return this.webServerHostname;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cliToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.webServerHostname());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCliTokenResponse)) {
            return false;
        }
        CreateCliTokenResponse other = (CreateCliTokenResponse)((Object)obj);
        return Objects.equals(this.cliToken(), other.cliToken()) && Objects.equals(this.webServerHostname(), other.webServerHostname());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCliTokenResponse").add("CliToken", (Object)(this.cliToken() == null ? null : "*** Sensitive Data Redacted ***")).add("WebServerHostname", (Object)this.webServerHostname()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CliToken": {
                return Optional.ofNullable(clazz.cast(this.cliToken()));
            }
            case "WebServerHostname": {
                return Optional.ofNullable(clazz.cast(this.webServerHostname()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCliTokenResponse, T> g) {
        return obj -> g.apply((CreateCliTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaResponse.BuilderImpl
    implements Builder {
        private String cliToken;
        private String webServerHostname;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCliTokenResponse model) {
            super(model);
            this.cliToken(model.cliToken);
            this.webServerHostname(model.webServerHostname);
        }

        public final String getCliToken() {
            return this.cliToken;
        }

        public final void setCliToken(String cliToken) {
            this.cliToken = cliToken;
        }

        @Override
        @Transient
        public final Builder cliToken(String cliToken) {
            this.cliToken = cliToken;
            return this;
        }

        public final String getWebServerHostname() {
            return this.webServerHostname;
        }

        public final void setWebServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
        }

        @Override
        @Transient
        public final Builder webServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
            return this;
        }

        @Override
        public CreateCliTokenResponse build() {
            return new CreateCliTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MwaaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCliTokenResponse> {
        public Builder cliToken(String var1);

        public Builder webServerHostname(String var1);
    }
}

