/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse;

public class ListWorkersWithQualificationTypePublisher
implements SdkPublisher<ListWorkersWithQualificationTypeResponse> {
    private final MTurkAsyncClient client;
    private final ListWorkersWithQualificationTypeRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkersWithQualificationTypePublisher(MTurkAsyncClient client, ListWorkersWithQualificationTypeRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkersWithQualificationTypePublisher(MTurkAsyncClient client, ListWorkersWithQualificationTypeRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkersWithQualificationTypeResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkersWithQualificationTypeResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListWorkersWithQualificationTypeResponseFetcher
    implements AsyncPageFetcher<ListWorkersWithQualificationTypeResponse> {
        private ListWorkersWithQualificationTypeResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkersWithQualificationTypeResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkersWithQualificationTypeResponse> nextPage(ListWorkersWithQualificationTypeResponse previousPage) {
            if (previousPage == null) {
                return ListWorkersWithQualificationTypePublisher.this.client.listWorkersWithQualificationType(ListWorkersWithQualificationTypePublisher.this.firstRequest);
            }
            return ListWorkersWithQualificationTypePublisher.this.client.listWorkersWithQualificationType((ListWorkersWithQualificationTypeRequest)((Object)ListWorkersWithQualificationTypePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

