/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyWorkersResponse extends MTurkResponse implements
        ToCopyableBuilder<NotifyWorkersResponse.Builder, NotifyWorkersResponse> {
    private static final SdkField<List<NotifyWorkersFailureStatus>> NOTIFY_WORKERS_FAILURE_STATUSES_FIELD = SdkField
            .<List<NotifyWorkersFailureStatus>> builder(MarshallingType.LIST)
            .memberName("NotifyWorkersFailureStatuses")
            .getter(getter(NotifyWorkersResponse::notifyWorkersFailureStatuses))
            .setter(setter(Builder::notifyWorkersFailureStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotifyWorkersFailureStatuses")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotifyWorkersFailureStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotifyWorkersFailureStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NOTIFY_WORKERS_FAILURE_STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses;

    private NotifyWorkersResponse(BuilderImpl builder) {
        super(builder);
        this.notifyWorkersFailureStatuses = builder.notifyWorkersFailureStatuses;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotifyWorkersFailureStatuses property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNotifyWorkersFailureStatuses() {
        return notifyWorkersFailureStatuses != null && !(notifyWorkersFailureStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this list of
     * NotifyWorkersFailureStatus objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotifyWorkersFailureStatuses} method.
     * </p>
     * 
     * @return When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this
     *         list of NotifyWorkersFailureStatus objects.
     */
    public final List<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses() {
        return notifyWorkersFailureStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNotifyWorkersFailureStatuses() ? notifyWorkersFailureStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyWorkersResponse)) {
            return false;
        }
        NotifyWorkersResponse other = (NotifyWorkersResponse) obj;
        return hasNotifyWorkersFailureStatuses() == other.hasNotifyWorkersFailureStatuses()
                && Objects.equals(notifyWorkersFailureStatuses(), other.notifyWorkersFailureStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotifyWorkersResponse")
                .add("NotifyWorkersFailureStatuses", hasNotifyWorkersFailureStatuses() ? notifyWorkersFailureStatuses() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotifyWorkersFailureStatuses":
            return Optional.ofNullable(clazz.cast(notifyWorkersFailureStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NotifyWorkersFailureStatuses", NOTIFY_WORKERS_FAILURE_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotifyWorkersResponse, T> g) {
        return obj -> g.apply((NotifyWorkersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, NotifyWorkersResponse> {
        /**
         * <p>
         * When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this
         * list of NotifyWorkersFailureStatus objects.
         * </p>
         * 
         * @param notifyWorkersFailureStatuses
         *        When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in
         *        this list of NotifyWorkersFailureStatus objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyWorkersFailureStatuses(Collection<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses);

        /**
         * <p>
         * When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this
         * list of NotifyWorkersFailureStatus objects.
         * </p>
         * 
         * @param notifyWorkersFailureStatuses
         *        When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in
         *        this list of NotifyWorkersFailureStatus objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyWorkersFailureStatuses(NotifyWorkersFailureStatus... notifyWorkersFailureStatuses);

        /**
         * <p>
         * When MTurk sends notifications to the list of Workers, it returns back any failures it encounters in this
         * list of NotifyWorkersFailureStatus objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureStatus.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureStatus.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #notifyWorkersFailureStatuses(List<NotifyWorkersFailureStatus>)}.
         * 
         * @param notifyWorkersFailureStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifyWorkersFailureStatuses(java.util.Collection<NotifyWorkersFailureStatus>)
         */
        Builder notifyWorkersFailureStatuses(Consumer<NotifyWorkersFailureStatus.Builder>... notifyWorkersFailureStatuses);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private List<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyWorkersResponse model) {
            super(model);
            notifyWorkersFailureStatuses(model.notifyWorkersFailureStatuses);
        }

        public final List<NotifyWorkersFailureStatus.Builder> getNotifyWorkersFailureStatuses() {
            List<NotifyWorkersFailureStatus.Builder> result = NotifyWorkersFailureStatusListCopier
                    .copyToBuilder(this.notifyWorkersFailureStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotifyWorkersFailureStatuses(
                Collection<NotifyWorkersFailureStatus.BuilderImpl> notifyWorkersFailureStatuses) {
            this.notifyWorkersFailureStatuses = NotifyWorkersFailureStatusListCopier
                    .copyFromBuilder(notifyWorkersFailureStatuses);
        }

        @Override
        public final Builder notifyWorkersFailureStatuses(Collection<NotifyWorkersFailureStatus> notifyWorkersFailureStatuses) {
            this.notifyWorkersFailureStatuses = NotifyWorkersFailureStatusListCopier.copy(notifyWorkersFailureStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifyWorkersFailureStatuses(NotifyWorkersFailureStatus... notifyWorkersFailureStatuses) {
            notifyWorkersFailureStatuses(Arrays.asList(notifyWorkersFailureStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifyWorkersFailureStatuses(
                Consumer<NotifyWorkersFailureStatus.Builder>... notifyWorkersFailureStatuses) {
            notifyWorkersFailureStatuses(Stream.of(notifyWorkersFailureStatuses)
                    .map(c -> NotifyWorkersFailureStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public NotifyWorkersResponse build() {
            return new NotifyWorkersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
