/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse;

public class ListReviewableHITsPublisher
implements SdkPublisher<ListReviewableHiTsResponse> {
    private final MTurkAsyncClient client;
    private final ListReviewableHiTsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReviewableHITsPublisher(MTurkAsyncClient client, ListReviewableHiTsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReviewableHITsPublisher(MTurkAsyncClient client, ListReviewableHiTsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReviewableHiTsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReviewableHiTsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListReviewableHITsPublisher resume(ListReviewableHiTsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListReviewableHITsPublisher(this.client, (ListReviewableHiTsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListReviewableHITsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListReviewableHiTsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListReviewableHiTsResponseFetcher
    implements AsyncPageFetcher<ListReviewableHiTsResponse> {
        private ListReviewableHiTsResponseFetcher() {
        }

        public boolean hasNextPage(ListReviewableHiTsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReviewableHiTsResponse> nextPage(ListReviewableHiTsResponse previousPage) {
            if (previousPage == null) {
                return ListReviewableHITsPublisher.this.client.listReviewableHITs(ListReviewableHITsPublisher.this.firstRequest);
            }
            return ListReviewableHITsPublisher.this.client.listReviewableHITs((ListReviewableHiTsRequest)((Object)ListReviewableHITsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

