/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationTransport {
    EMAIL("Email"),
    SQS("SQS"),
    SNS("SNS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationTransport> VALUE_MAP;
    private final String value;

    private NotificationTransport(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationTransport fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationTransport> knownValues() {
        EnumSet<NotificationTransport> knownValues = EnumSet.allOf(NotificationTransport.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationTransport.class, NotificationTransport::toString);
    }
}

