/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.services.mturk.model.QualificationType;
import software.amazon.awssdk.services.mturk.model.QualificationTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQualificationTypesResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListQualificationTypesResponse> {
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumResults").getter(ListQualificationTypesResponse.getter(ListQualificationTypesResponse::numResults)).setter(ListQualificationTypesResponse.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQualificationTypesResponse.getter(ListQualificationTypesResponse::nextToken)).setter(ListQualificationTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<QualificationType>> QUALIFICATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QualificationTypes").getter(ListQualificationTypesResponse.getter(ListQualificationTypesResponse::qualificationTypes)).setter(ListQualificationTypesResponse.setter(Builder::qualificationTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QualificationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_RESULTS_FIELD, NEXT_TOKEN_FIELD, QUALIFICATION_TYPES_FIELD));
    private final Integer numResults;
    private final String nextToken;
    private final List<QualificationType> qualificationTypes;

    private ListQualificationTypesResponse(BuilderImpl builder) {
        super(builder);
        this.numResults = builder.numResults;
        this.nextToken = builder.nextToken;
        this.qualificationTypes = builder.qualificationTypes;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasQualificationTypes() {
        return this.qualificationTypes != null && !(this.qualificationTypes instanceof SdkAutoConstructList);
    }

    public final List<QualificationType> qualificationTypes() {
        return this.qualificationTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQualificationTypes() ? this.qualificationTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQualificationTypesResponse)) {
            return false;
        }
        ListQualificationTypesResponse other = (ListQualificationTypesResponse)((Object)obj);
        return Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasQualificationTypes() == other.hasQualificationTypes() && Objects.equals(this.qualificationTypes(), other.qualificationTypes());
    }

    public final String toString() {
        return ToString.builder((String)"ListQualificationTypesResponse").add("NumResults", (Object)this.numResults()).add("NextToken", (Object)this.nextToken()).add("QualificationTypes", this.hasQualificationTypes() ? this.qualificationTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "QualificationTypes": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQualificationTypesResponse, T> g) {
        return obj -> g.apply((ListQualificationTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private Integer numResults;
        private String nextToken;
        private List<QualificationType> qualificationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQualificationTypesResponse model) {
            super(model);
            this.numResults(model.numResults);
            this.nextToken(model.nextToken);
            this.qualificationTypes(model.qualificationTypes);
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        @Transient
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QualificationType.Builder> getQualificationTypes() {
            List<QualificationType.Builder> result = QualificationTypeListCopier.copyToBuilder(this.qualificationTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQualificationTypes(Collection<QualificationType.BuilderImpl> qualificationTypes) {
            this.qualificationTypes = QualificationTypeListCopier.copyFromBuilder(qualificationTypes);
        }

        @Override
        @Transient
        public final Builder qualificationTypes(Collection<QualificationType> qualificationTypes) {
            this.qualificationTypes = QualificationTypeListCopier.copy(qualificationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder qualificationTypes(QualificationType ... qualificationTypes) {
            this.qualificationTypes(Arrays.asList(qualificationTypes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder qualificationTypes(Consumer<QualificationType.Builder> ... qualificationTypes) {
            this.qualificationTypes(Stream.of(qualificationTypes).map(c -> (QualificationType)((QualificationType.Builder)QualificationType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListQualificationTypesResponse build() {
            return new ListQualificationTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQualificationTypesResponse> {
        public Builder numResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder qualificationTypes(Collection<QualificationType> var1);

        public Builder qualificationTypes(QualificationType ... var1);

        public Builder qualificationTypes(Consumer<QualificationType.Builder> ... var1);
    }
}

