/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFileUploadUrlRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, GetFileUploadUrlRequest> {
    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentId").getter(GetFileUploadUrlRequest.getter(GetFileUploadUrlRequest::assignmentId)).setter(GetFileUploadUrlRequest.setter(Builder::assignmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()}).build();
    private static final SdkField<String> QUESTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionIdentifier").getter(GetFileUploadUrlRequest.getter(GetFileUploadUrlRequest::questionIdentifier)).setter(GetFileUploadUrlRequest.setter(Builder::questionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_ID_FIELD, QUESTION_IDENTIFIER_FIELD));
    private final String assignmentId;
    private final String questionIdentifier;

    private GetFileUploadUrlRequest(BuilderImpl builder) {
        super(builder);
        this.assignmentId = builder.assignmentId;
        this.questionIdentifier = builder.questionIdentifier;
    }

    public String assignmentId() {
        return this.assignmentId;
    }

    public String questionIdentifier() {
        return this.questionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFileUploadUrlRequest)) {
            return false;
        }
        GetFileUploadUrlRequest other = (GetFileUploadUrlRequest)((Object)obj);
        return Objects.equals(this.assignmentId(), other.assignmentId()) && Objects.equals(this.questionIdentifier(), other.questionIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"GetFileUploadUrlRequest").add("AssignmentId", (Object)this.assignmentId()).add("QuestionIdentifier", (Object)this.questionIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignmentId": {
                return Optional.ofNullable(clazz.cast(this.assignmentId()));
            }
            case "QuestionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.questionIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFileUploadUrlRequest, T> g) {
        return obj -> g.apply((GetFileUploadUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String assignmentId;
        private String questionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFileUploadUrlRequest model) {
            super(model);
            this.assignmentId(model.assignmentId);
            this.questionIdentifier(model.questionIdentifier);
        }

        public final String getAssignmentId() {
            return this.assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        public final String getQuestionIdentifier() {
            return this.questionIdentifier;
        }

        @Override
        public final Builder questionIdentifier(String questionIdentifier) {
            this.questionIdentifier = questionIdentifier;
            return this;
        }

        public final void setQuestionIdentifier(String questionIdentifier) {
            this.questionIdentifier = questionIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFileUploadUrlRequest build() {
            return new GetFileUploadUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFileUploadUrlRequest> {
        public Builder assignmentId(String var1);

        public Builder questionIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

