/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse;

public class ListQualificationTypesPublisher
implements SdkPublisher<ListQualificationTypesResponse> {
    private final MTurkAsyncClient client;
    private final ListQualificationTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQualificationTypesPublisher(MTurkAsyncClient client, ListQualificationTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQualificationTypesPublisher(MTurkAsyncClient client, ListQualificationTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQualificationTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQualificationTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListQualificationTypesResponseFetcher
    implements AsyncPageFetcher<ListQualificationTypesResponse> {
        private ListQualificationTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListQualificationTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQualificationTypesResponse> nextPage(ListQualificationTypesResponse previousPage) {
            if (previousPage == null) {
                return ListQualificationTypesPublisher.this.client.listQualificationTypes(ListQualificationTypesPublisher.this.firstRequest);
            }
            return ListQualificationTypesPublisher.this.client.listQualificationTypes((ListQualificationTypesRequest)((Object)ListQualificationTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

