/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.HITLayoutParameter;
import software.amazon.awssdk.services.mturk.model.HITLayoutParameterListCopier;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.ReviewPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHitWithHitTypeRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, CreateHitWithHitTypeRequest> {
    private static final SdkField<String> HIT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::hitTypeId)).setter(CreateHitWithHitTypeRequest.setter(Builder::hitTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITTypeId").build()}).build();
    private static final SdkField<Integer> MAX_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::maxAssignments)).setter(CreateHitWithHitTypeRequest.setter(Builder::maxAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAssignments").build()}).build();
    private static final SdkField<Long> LIFETIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::lifetimeInSeconds)).setter(CreateHitWithHitTypeRequest.setter(Builder::lifetimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifetimeInSeconds").build()}).build();
    private static final SdkField<String> QUESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::question)).setter(CreateHitWithHitTypeRequest.setter(Builder::question)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Question").build()}).build();
    private static final SdkField<String> REQUESTER_ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::requesterAnnotation)).setter(CreateHitWithHitTypeRequest.setter(Builder::requesterAnnotation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterAnnotation").build()}).build();
    private static final SdkField<String> UNIQUE_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::uniqueRequestToken)).setter(CreateHitWithHitTypeRequest.setter(Builder::uniqueRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueRequestToken").build()}).build();
    private static final SdkField<ReviewPolicy> ASSIGNMENT_REVIEW_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::assignmentReviewPolicy)).setter(CreateHitWithHitTypeRequest.setter(Builder::assignmentReviewPolicy)).constructor(ReviewPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentReviewPolicy").build()}).build();
    private static final SdkField<ReviewPolicy> HIT_REVIEW_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::hitReviewPolicy)).setter(CreateHitWithHitTypeRequest.setter(Builder::hitReviewPolicy)).constructor(ReviewPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITReviewPolicy").build()}).build();
    private static final SdkField<String> HIT_LAYOUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::hitLayoutId)).setter(CreateHitWithHitTypeRequest.setter(Builder::hitLayoutId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITLayoutId").build()}).build();
    private static final SdkField<List<HITLayoutParameter>> HIT_LAYOUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateHitWithHitTypeRequest.getter(CreateHitWithHitTypeRequest::hitLayoutParameters)).setter(CreateHitWithHitTypeRequest.setter(Builder::hitLayoutParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITLayoutParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HITLayoutParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_TYPE_ID_FIELD, MAX_ASSIGNMENTS_FIELD, LIFETIME_IN_SECONDS_FIELD, QUESTION_FIELD, REQUESTER_ANNOTATION_FIELD, UNIQUE_REQUEST_TOKEN_FIELD, ASSIGNMENT_REVIEW_POLICY_FIELD, HIT_REVIEW_POLICY_FIELD, HIT_LAYOUT_ID_FIELD, HIT_LAYOUT_PARAMETERS_FIELD));
    private final String hitTypeId;
    private final Integer maxAssignments;
    private final Long lifetimeInSeconds;
    private final String question;
    private final String requesterAnnotation;
    private final String uniqueRequestToken;
    private final ReviewPolicy assignmentReviewPolicy;
    private final ReviewPolicy hitReviewPolicy;
    private final String hitLayoutId;
    private final List<HITLayoutParameter> hitLayoutParameters;

    private CreateHitWithHitTypeRequest(BuilderImpl builder) {
        super(builder);
        this.hitTypeId = builder.hitTypeId;
        this.maxAssignments = builder.maxAssignments;
        this.lifetimeInSeconds = builder.lifetimeInSeconds;
        this.question = builder.question;
        this.requesterAnnotation = builder.requesterAnnotation;
        this.uniqueRequestToken = builder.uniqueRequestToken;
        this.assignmentReviewPolicy = builder.assignmentReviewPolicy;
        this.hitReviewPolicy = builder.hitReviewPolicy;
        this.hitLayoutId = builder.hitLayoutId;
        this.hitLayoutParameters = builder.hitLayoutParameters;
    }

    public String hitTypeId() {
        return this.hitTypeId;
    }

    public Integer maxAssignments() {
        return this.maxAssignments;
    }

    public Long lifetimeInSeconds() {
        return this.lifetimeInSeconds;
    }

    public String question() {
        return this.question;
    }

    public String requesterAnnotation() {
        return this.requesterAnnotation;
    }

    public String uniqueRequestToken() {
        return this.uniqueRequestToken;
    }

    public ReviewPolicy assignmentReviewPolicy() {
        return this.assignmentReviewPolicy;
    }

    public ReviewPolicy hitReviewPolicy() {
        return this.hitReviewPolicy;
    }

    public String hitLayoutId() {
        return this.hitLayoutId;
    }

    public boolean hasHitLayoutParameters() {
        return this.hitLayoutParameters != null && !(this.hitLayoutParameters instanceof SdkAutoConstructList);
    }

    public List<HITLayoutParameter> hitLayoutParameters() {
        return this.hitLayoutParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hitTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifetimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.question());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterAnnotation());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitLayoutId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitLayoutParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHitWithHitTypeRequest)) {
            return false;
        }
        CreateHitWithHitTypeRequest other = (CreateHitWithHitTypeRequest)((Object)obj);
        return Objects.equals(this.hitTypeId(), other.hitTypeId()) && Objects.equals(this.maxAssignments(), other.maxAssignments()) && Objects.equals(this.lifetimeInSeconds(), other.lifetimeInSeconds()) && Objects.equals(this.question(), other.question()) && Objects.equals(this.requesterAnnotation(), other.requesterAnnotation()) && Objects.equals(this.uniqueRequestToken(), other.uniqueRequestToken()) && Objects.equals(this.assignmentReviewPolicy(), other.assignmentReviewPolicy()) && Objects.equals(this.hitReviewPolicy(), other.hitReviewPolicy()) && Objects.equals(this.hitLayoutId(), other.hitLayoutId()) && Objects.equals(this.hitLayoutParameters(), other.hitLayoutParameters());
    }

    public String toString() {
        return ToString.builder((String)"CreateHitWithHitTypeRequest").add("HITTypeId", (Object)this.hitTypeId()).add("MaxAssignments", (Object)this.maxAssignments()).add("LifetimeInSeconds", (Object)this.lifetimeInSeconds()).add("Question", (Object)this.question()).add("RequesterAnnotation", (Object)this.requesterAnnotation()).add("UniqueRequestToken", (Object)this.uniqueRequestToken()).add("AssignmentReviewPolicy", (Object)this.assignmentReviewPolicy()).add("HITReviewPolicy", (Object)this.hitReviewPolicy()).add("HITLayoutId", (Object)this.hitLayoutId()).add("HITLayoutParameters", this.hitLayoutParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITTypeId": {
                return Optional.ofNullable(clazz.cast(this.hitTypeId()));
            }
            case "MaxAssignments": {
                return Optional.ofNullable(clazz.cast(this.maxAssignments()));
            }
            case "LifetimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.lifetimeInSeconds()));
            }
            case "Question": {
                return Optional.ofNullable(clazz.cast(this.question()));
            }
            case "RequesterAnnotation": {
                return Optional.ofNullable(clazz.cast(this.requesterAnnotation()));
            }
            case "UniqueRequestToken": {
                return Optional.ofNullable(clazz.cast(this.uniqueRequestToken()));
            }
            case "AssignmentReviewPolicy": {
                return Optional.ofNullable(clazz.cast(this.assignmentReviewPolicy()));
            }
            case "HITReviewPolicy": {
                return Optional.ofNullable(clazz.cast(this.hitReviewPolicy()));
            }
            case "HITLayoutId": {
                return Optional.ofNullable(clazz.cast(this.hitLayoutId()));
            }
            case "HITLayoutParameters": {
                return Optional.ofNullable(clazz.cast(this.hitLayoutParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHitWithHitTypeRequest, T> g) {
        return obj -> g.apply((CreateHitWithHitTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitTypeId;
        private Integer maxAssignments;
        private Long lifetimeInSeconds;
        private String question;
        private String requesterAnnotation;
        private String uniqueRequestToken;
        private ReviewPolicy assignmentReviewPolicy;
        private ReviewPolicy hitReviewPolicy;
        private String hitLayoutId;
        private List<HITLayoutParameter> hitLayoutParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHitWithHitTypeRequest model) {
            super(model);
            this.hitTypeId(model.hitTypeId);
            this.maxAssignments(model.maxAssignments);
            this.lifetimeInSeconds(model.lifetimeInSeconds);
            this.question(model.question);
            this.requesterAnnotation(model.requesterAnnotation);
            this.uniqueRequestToken(model.uniqueRequestToken);
            this.assignmentReviewPolicy(model.assignmentReviewPolicy);
            this.hitReviewPolicy(model.hitReviewPolicy);
            this.hitLayoutId(model.hitLayoutId);
            this.hitLayoutParameters(model.hitLayoutParameters);
        }

        public final String getHitTypeId() {
            return this.hitTypeId;
        }

        @Override
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final void setHitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        public final Integer getMaxAssignments() {
            return this.maxAssignments;
        }

        @Override
        public final Builder maxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
            return this;
        }

        public final void setMaxAssignments(Integer maxAssignments) {
            this.maxAssignments = maxAssignments;
        }

        public final Long getLifetimeInSeconds() {
            return this.lifetimeInSeconds;
        }

        @Override
        public final Builder lifetimeInSeconds(Long lifetimeInSeconds) {
            this.lifetimeInSeconds = lifetimeInSeconds;
            return this;
        }

        public final void setLifetimeInSeconds(Long lifetimeInSeconds) {
            this.lifetimeInSeconds = lifetimeInSeconds;
        }

        public final String getQuestion() {
            return this.question;
        }

        @Override
        public final Builder question(String question) {
            this.question = question;
            return this;
        }

        public final void setQuestion(String question) {
            this.question = question;
        }

        public final String getRequesterAnnotation() {
            return this.requesterAnnotation;
        }

        @Override
        public final Builder requesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
            return this;
        }

        public final void setRequesterAnnotation(String requesterAnnotation) {
            this.requesterAnnotation = requesterAnnotation;
        }

        public final String getUniqueRequestToken() {
            return this.uniqueRequestToken;
        }

        @Override
        public final Builder uniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
            return this;
        }

        public final void setUniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
        }

        public final ReviewPolicy.Builder getAssignmentReviewPolicy() {
            return this.assignmentReviewPolicy != null ? this.assignmentReviewPolicy.toBuilder() : null;
        }

        @Override
        public final Builder assignmentReviewPolicy(ReviewPolicy assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy;
            return this;
        }

        public final void setAssignmentReviewPolicy(ReviewPolicy.BuilderImpl assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy != null ? assignmentReviewPolicy.build() : null;
        }

        public final ReviewPolicy.Builder getHitReviewPolicy() {
            return this.hitReviewPolicy != null ? this.hitReviewPolicy.toBuilder() : null;
        }

        @Override
        public final Builder hitReviewPolicy(ReviewPolicy hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy;
            return this;
        }

        public final void setHitReviewPolicy(ReviewPolicy.BuilderImpl hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy != null ? hitReviewPolicy.build() : null;
        }

        public final String getHitLayoutId() {
            return this.hitLayoutId;
        }

        @Override
        public final Builder hitLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
            return this;
        }

        public final void setHitLayoutId(String hitLayoutId) {
            this.hitLayoutId = hitLayoutId;
        }

        public final Collection<HITLayoutParameter.Builder> getHitLayoutParameters() {
            return this.hitLayoutParameters != null ? (Collection)this.hitLayoutParameters.stream().map(HITLayoutParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hitLayoutParameters(Collection<HITLayoutParameter> hitLayoutParameters) {
            this.hitLayoutParameters = HITLayoutParameterListCopier.copy(hitLayoutParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hitLayoutParameters(HITLayoutParameter ... hitLayoutParameters) {
            this.hitLayoutParameters(Arrays.asList(hitLayoutParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hitLayoutParameters(Consumer<HITLayoutParameter.Builder> ... hitLayoutParameters) {
            this.hitLayoutParameters(Stream.of(hitLayoutParameters).map(c -> (HITLayoutParameter)((HITLayoutParameter.Builder)HITLayoutParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHitLayoutParameters(Collection<HITLayoutParameter.BuilderImpl> hitLayoutParameters) {
            this.hitLayoutParameters = HITLayoutParameterListCopier.copyFromBuilder(hitLayoutParameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHitWithHitTypeRequest build() {
            return new CreateHitWithHitTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHitWithHitTypeRequest> {
        public Builder hitTypeId(String var1);

        public Builder maxAssignments(Integer var1);

        public Builder lifetimeInSeconds(Long var1);

        public Builder question(String var1);

        public Builder requesterAnnotation(String var1);

        public Builder uniqueRequestToken(String var1);

        public Builder assignmentReviewPolicy(ReviewPolicy var1);

        default public Builder assignmentReviewPolicy(Consumer<ReviewPolicy.Builder> assignmentReviewPolicy) {
            return this.assignmentReviewPolicy((ReviewPolicy)((ReviewPolicy.Builder)ReviewPolicy.builder().applyMutation(assignmentReviewPolicy)).build());
        }

        public Builder hitReviewPolicy(ReviewPolicy var1);

        default public Builder hitReviewPolicy(Consumer<ReviewPolicy.Builder> hitReviewPolicy) {
            return this.hitReviewPolicy((ReviewPolicy)((ReviewPolicy.Builder)ReviewPolicy.builder().applyMutation(hitReviewPolicy)).build());
        }

        public Builder hitLayoutId(String var1);

        public Builder hitLayoutParameters(Collection<HITLayoutParameter> var1);

        public Builder hitLayoutParameters(HITLayoutParameter ... var1);

        public Builder hitLayoutParameters(Consumer<HITLayoutParameter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

