/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.SendBonusRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SendBonusRequestModelMarshaller {
    private static final MarshallingInfo<String> WORKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerId").isBinary(false).build();
    private static final MarshallingInfo<String> BONUSAMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BonusAmount").isBinary(false).build();
    private static final MarshallingInfo<String> ASSIGNMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentId").isBinary(false).build();
    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Reason").isBinary(false).build();
    private static final MarshallingInfo<String> UNIQUEREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UniqueRequestToken").isBinary(false).build();
    private static final SendBonusRequestModelMarshaller INSTANCE = new SendBonusRequestModelMarshaller();

    private SendBonusRequestModelMarshaller() {
    }

    public static SendBonusRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SendBonusRequest sendBonusRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)sendBonusRequest), (String)"sendBonusRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sendBonusRequest.workerId(), WORKERID_BINDING);
            protocolMarshaller.marshall((Object)sendBonusRequest.bonusAmount(), BONUSAMOUNT_BINDING);
            protocolMarshaller.marshall((Object)sendBonusRequest.assignmentId(), ASSIGNMENTID_BINDING);
            protocolMarshaller.marshall((Object)sendBonusRequest.reason(), REASON_BINDING);
            protocolMarshaller.marshall((Object)sendBonusRequest.uniqueRequestToken(), UNIQUEREQUESTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

