/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.ReviewPolicy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReviewPolicyMarshaller {
    private static final MarshallingInfo<String> POLICYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyName").isBinary(false).build();
    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final ReviewPolicyMarshaller INSTANCE = new ReviewPolicyMarshaller();

    private ReviewPolicyMarshaller() {
    }

    public static ReviewPolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReviewPolicy reviewPolicy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reviewPolicy, (String)"reviewPolicy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reviewPolicy.policyName(), POLICYNAME_BINDING);
            protocolMarshaller.marshall(reviewPolicy.parameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

