/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.ReviewActionDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReviewActionDetailMarshaller {
    private static final MarshallingInfo<String> ACTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionId").isBinary(false).build();
    private static final MarshallingInfo<String> ACTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionName").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetId").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetType").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Instant> COMPLETETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompleteTime").isBinary(false).build();
    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Result").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final ReviewActionDetailMarshaller INSTANCE = new ReviewActionDetailMarshaller();

    private ReviewActionDetailMarshaller() {
    }

    public static ReviewActionDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReviewActionDetail reviewActionDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reviewActionDetail, (String)"reviewActionDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reviewActionDetail.actionId(), ACTIONID_BINDING);
            protocolMarshaller.marshall((Object)reviewActionDetail.actionName(), ACTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)reviewActionDetail.targetId(), TARGETID_BINDING);
            protocolMarshaller.marshall((Object)reviewActionDetail.targetType(), TARGETTYPE_BINDING);
            protocolMarshaller.marshall((Object)reviewActionDetail.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)reviewActionDetail.completeTime(), COMPLETETIME_BINDING);
            protocolMarshaller.marshall((Object)reviewActionDetail.result(), RESULT_BINDING);
            protocolMarshaller.marshall((Object)reviewActionDetail.errorCode(), ERRORCODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

