/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.QualificationRequirement;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QualificationRequirementMarshaller {
    private static final MarshallingInfo<String> QUALIFICATIONTYPEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationTypeId").isBinary(false).build();
    private static final MarshallingInfo<String> COMPARATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comparator").isBinary(false).build();
    private static final MarshallingInfo<List> INTEGERVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegerValues").isBinary(false).build();
    private static final MarshallingInfo<List> LOCALEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocaleValues").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REQUIREDTOPREVIEW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequiredToPreview").isBinary(false).build();
    private static final MarshallingInfo<String> ACTIONSGUARDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionsGuarded").isBinary(false).build();
    private static final QualificationRequirementMarshaller INSTANCE = new QualificationRequirementMarshaller();

    private QualificationRequirementMarshaller() {
    }

    public static QualificationRequirementMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QualificationRequirement qualificationRequirement, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)qualificationRequirement, (String)"qualificationRequirement");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)qualificationRequirement.qualificationTypeId(), QUALIFICATIONTYPEID_BINDING);
            protocolMarshaller.marshall((Object)qualificationRequirement.comparatorAsString(), COMPARATOR_BINDING);
            protocolMarshaller.marshall(qualificationRequirement.integerValues(), INTEGERVALUES_BINDING);
            protocolMarshaller.marshall(qualificationRequirement.localeValues(), LOCALEVALUES_BINDING);
            protocolMarshaller.marshall((Object)qualificationRequirement.requiredToPreview(), REQUIREDTOPREVIEW_BINDING);
            protocolMarshaller.marshall((Object)qualificationRequirement.actionsGuardedAsString(), ACTIONSGUARDED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

