/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.QualificationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QualificationRequestMarshaller {
    private static final MarshallingInfo<String> QUALIFICATIONREQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationRequestId").isBinary(false).build();
    private static final MarshallingInfo<String> QUALIFICATIONTYPEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationTypeId").isBinary(false).build();
    private static final MarshallingInfo<String> WORKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerId").isBinary(false).build();
    private static final MarshallingInfo<String> TEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Test").isBinary(false).build();
    private static final MarshallingInfo<String> ANSWER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Answer").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTime").isBinary(false).build();
    private static final QualificationRequestMarshaller INSTANCE = new QualificationRequestMarshaller();

    private QualificationRequestMarshaller() {
    }

    public static QualificationRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QualificationRequest qualificationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)qualificationRequest, (String)"qualificationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)qualificationRequest.qualificationRequestId(), QUALIFICATIONREQUESTID_BINDING);
            protocolMarshaller.marshall((Object)qualificationRequest.qualificationTypeId(), QUALIFICATIONTYPEID_BINDING);
            protocolMarshaller.marshall((Object)qualificationRequest.workerId(), WORKERID_BINDING);
            protocolMarshaller.marshall((Object)qualificationRequest.test(), TEST_BINDING);
            protocolMarshaller.marshall((Object)qualificationRequest.answer(), ANSWER_BINDING);
            protocolMarshaller.marshall((Object)qualificationRequest.submitTime(), SUBMITTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

