/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.model.Qualification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QualificationMarshaller {
    private static final MarshallingInfo<String> QUALIFICATIONTYPEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationTypeId").isBinary(false).build();
    private static final MarshallingInfo<String> WORKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerId").isBinary(false).build();
    private static final MarshallingInfo<Instant> GRANTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> INTEGERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegerValue").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCALEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocaleValue").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final QualificationMarshaller INSTANCE = new QualificationMarshaller();

    private QualificationMarshaller() {
    }

    public static QualificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Qualification qualification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)qualification, (String)"qualification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)qualification.qualificationTypeId(), QUALIFICATIONTYPEID_BINDING);
            protocolMarshaller.marshall((Object)qualification.workerId(), WORKERID_BINDING);
            protocolMarshaller.marshall((Object)qualification.grantTime(), GRANTTIME_BINDING);
            protocolMarshaller.marshall((Object)qualification.integerValue(), INTEGERVALUE_BINDING);
            protocolMarshaller.marshall((Object)qualification.localeValue(), LOCALEVALUE_BINDING);
            protocolMarshaller.marshall((Object)qualification.statusAsString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

