/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest;
import software.amazon.awssdk.services.mturk.transform.NotifyWorkersRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotifyWorkersRequestMarshaller
implements Marshaller<Request<NotifyWorkersRequest>, NotifyWorkersRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("MTurkRequesterServiceV20170117.NotifyWorkers").serviceName("Amazon MTurk").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public NotifyWorkersRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<NotifyWorkersRequest> marshall(NotifyWorkersRequest notifyWorkersRequest) {
        Validate.paramNotNull((Object)((Object)notifyWorkersRequest), (String)"notifyWorkersRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)notifyWorkersRequest);
            protocolMarshaller.startMarshalling();
            NotifyWorkersRequestModelMarshaller.getInstance().marshall(notifyWorkersRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

