/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.NotificationSpecification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotificationSpecificationMarshaller {
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Destination").isBinary(false).build();
    private static final MarshallingInfo<String> TRANSPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Transport").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventTypes").isBinary(false).build();
    private static final NotificationSpecificationMarshaller INSTANCE = new NotificationSpecificationMarshaller();

    private NotificationSpecificationMarshaller() {
    }

    public static NotificationSpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NotificationSpecification notificationSpecification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)notificationSpecification, (String)"notificationSpecification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)notificationSpecification.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)notificationSpecification.transportAsString(), TRANSPORT_BINDING);
            protocolMarshaller.marshall((Object)notificationSpecification.version(), VERSION_BINDING);
            protocolMarshaller.marshall(notificationSpecification.eventTypesAsStrings(), EVENTTYPES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

