/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mturk.model.Locale;

public class LocaleUnmarshaller
implements Unmarshaller<Locale, JsonUnmarshallerContext> {
    private static final LocaleUnmarshaller INSTANCE = new LocaleUnmarshaller();

    public Locale unmarshall(JsonUnmarshallerContext context) throws Exception {
        Locale.Builder localeBuilder = Locale.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Country", targetDepth)) {
                    context.nextToken();
                    localeBuilder.country((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Subdivision", targetDepth)) {
                    context.nextToken();
                    localeBuilder.subdivision((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Locale)localeBuilder.build();
    }

    public static LocaleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

