/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mturk.model.HIT;
import software.amazon.awssdk.services.mturk.transform.QualificationRequirementUnmarshaller;

public class HITUnmarshaller
implements Unmarshaller<HIT, JsonUnmarshallerContext> {
    private static final HITUnmarshaller INSTANCE = new HITUnmarshaller();

    public HIT unmarshall(JsonUnmarshallerContext context) throws Exception {
        HIT.Builder hitBuilder = HIT.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("HITId", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HITTypeId", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitTypeId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HITGroupId", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitGroupId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HITLayoutId", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitLayoutId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    hitBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Title", targetDepth)) {
                    context.nextToken();
                    hitBuilder.title((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    hitBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Question", targetDepth)) {
                    context.nextToken();
                    hitBuilder.question((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Keywords", targetDepth)) {
                    context.nextToken();
                    hitBuilder.keywords((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HITStatus", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaxAssignments", targetDepth)) {
                    context.nextToken();
                    hitBuilder.maxAssignments((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Reward", targetDepth)) {
                    context.nextToken();
                    hitBuilder.reward((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AutoApprovalDelayInSeconds", targetDepth)) {
                    context.nextToken();
                    hitBuilder.autoApprovalDelayInSeconds((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Expiration", targetDepth)) {
                    context.nextToken();
                    hitBuilder.expiration((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("AssignmentDurationInSeconds", targetDepth)) {
                    context.nextToken();
                    hitBuilder.assignmentDurationInSeconds((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("RequesterAnnotation", targetDepth)) {
                    context.nextToken();
                    hitBuilder.requesterAnnotation((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("QualificationRequirements", targetDepth)) {
                    context.nextToken();
                    hitBuilder.qualificationRequirements(new ListUnmarshaller((Unmarshaller)QualificationRequirementUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("HITReviewStatus", targetDepth)) {
                    context.nextToken();
                    hitBuilder.hitReviewStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NumberOfAssignmentsPending", targetDepth)) {
                    context.nextToken();
                    hitBuilder.numberOfAssignmentsPending((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("NumberOfAssignmentsAvailable", targetDepth)) {
                    context.nextToken();
                    hitBuilder.numberOfAssignmentsAvailable((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("NumberOfAssignmentsCompleted", targetDepth)) {
                    context.nextToken();
                    hitBuilder.numberOfAssignmentsCompleted((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HIT)hitBuilder.build();
    }

    public static HITUnmarshaller getInstance() {
        return INSTANCE;
    }
}

