/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.HITLayoutParameter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HITLayoutParameterMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final HITLayoutParameterMarshaller INSTANCE = new HITLayoutParameterMarshaller();

    private HITLayoutParameterMarshaller() {
    }

    public static HITLayoutParameterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HITLayoutParameter hitLayoutParameter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hitLayoutParameter, (String)"hitLayoutParameter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hitLayoutParameter.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)hitLayoutParameter.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

