/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.model.CreateHitRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateHitRequestModelMarshaller {
    private static final MarshallingInfo<Integer> MAXASSIGNMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxAssignments").isBinary(false).build();
    private static final MarshallingInfo<Long> AUTOAPPROVALDELAYINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoApprovalDelayInSeconds").isBinary(false).build();
    private static final MarshallingInfo<Long> LIFETIMEINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifetimeInSeconds").isBinary(false).build();
    private static final MarshallingInfo<Long> ASSIGNMENTDURATIONINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentDurationInSeconds").isBinary(false).build();
    private static final MarshallingInfo<String> REWARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Reward").isBinary(false).build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();
    private static final MarshallingInfo<String> KEYWORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keywords").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> QUESTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Question").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTERANNOTATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequesterAnnotation").isBinary(false).build();
    private static final MarshallingInfo<List> QUALIFICATIONREQUIREMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QualificationRequirements").isBinary(false).build();
    private static final MarshallingInfo<String> UNIQUEREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UniqueRequestToken").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ASSIGNMENTREVIEWPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentReviewPolicy").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HITREVIEWPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITReviewPolicy").isBinary(false).build();
    private static final MarshallingInfo<String> HITLAYOUTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITLayoutId").isBinary(false).build();
    private static final MarshallingInfo<List> HITLAYOUTPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HITLayoutParameters").isBinary(false).build();
    private static final CreateHitRequestModelMarshaller INSTANCE = new CreateHitRequestModelMarshaller();

    private CreateHitRequestModelMarshaller() {
    }

    public static CreateHitRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateHitRequest createHitRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createHitRequest), (String)"createHitRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createHitRequest.maxAssignments(), MAXASSIGNMENTS_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.autoApprovalDelayInSeconds(), AUTOAPPROVALDELAYINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.lifetimeInSeconds(), LIFETIMEINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.assignmentDurationInSeconds(), ASSIGNMENTDURATIONINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.reward(), REWARD_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.keywords(), KEYWORDS_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.question(), QUESTION_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.requesterAnnotation(), REQUESTERANNOTATION_BINDING);
            protocolMarshaller.marshall(createHitRequest.qualificationRequirements(), QUALIFICATIONREQUIREMENTS_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.uniqueRequestToken(), UNIQUEREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.assignmentReviewPolicy(), ASSIGNMENTREVIEWPOLICY_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.hitReviewPolicy(), HITREVIEWPOLICY_BINDING);
            protocolMarshaller.marshall((Object)createHitRequest.hitLayoutId(), HITLAYOUTID_BINDING);
            protocolMarshaller.marshall(createHitRequest.hitLayoutParameters(), HITLAYOUTPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

