/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mturk.model.BonusPayment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BonusPaymentMarshaller {
    private static final MarshallingInfo<String> WORKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkerId").isBinary(false).build();
    private static final MarshallingInfo<String> BONUSAMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BonusAmount").isBinary(false).build();
    private static final MarshallingInfo<String> ASSIGNMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssignmentId").isBinary(false).build();
    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Reason").isBinary(false).build();
    private static final MarshallingInfo<Instant> GRANTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantTime").isBinary(false).build();
    private static final BonusPaymentMarshaller INSTANCE = new BonusPaymentMarshaller();

    private BonusPaymentMarshaller() {
    }

    public static BonusPaymentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BonusPayment bonusPayment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)bonusPayment, (String)"bonusPayment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)bonusPayment.workerId(), WORKERID_BINDING);
            protocolMarshaller.marshall((Object)bonusPayment.bonusAmount(), BONUSAMOUNT_BINDING);
            protocolMarshaller.marshall((Object)bonusPayment.assignmentId(), ASSIGNMENTID_BINDING);
            protocolMarshaller.marshall((Object)bonusPayment.reason(), REASON_BINDING);
            protocolMarshaller.marshall((Object)bonusPayment.grantTime(), GRANTTIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

