/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.WorkerBlockMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerBlock
implements StructuredPojo,
ToCopyableBuilder<Builder, WorkerBlock> {
    private final String workerId;
    private final String reason;

    private WorkerBlock(BuilderImpl builder) {
        this.workerId = builder.workerId;
        this.reason = builder.reason;
    }

    public String workerId() {
        return this.workerId;
    }

    public String reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerBlock)) {
            return false;
        }
        WorkerBlock other = (WorkerBlock)obj;
        return Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.reason(), other.reason());
    }

    public String toString() {
        return ToString.builder((String)"WorkerBlock").add("WorkerId", (Object)this.workerId()).add("Reason", (Object)this.reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkerBlockMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String workerId;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerBlock model) {
            this.workerId(model.workerId);
            this.reason(model.reason);
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public WorkerBlock build() {
            return new WorkerBlock(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WorkerBlock> {
        public Builder workerId(String var1);

        public Builder reason(String var1);
    }
}

