/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.NotificationSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNotificationSettingsRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, UpdateNotificationSettingsRequest> {
    private final String hitTypeId;
    private final NotificationSpecification notification;
    private final Boolean active;

    private UpdateNotificationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.hitTypeId = builder.hitTypeId;
        this.notification = builder.notification;
        this.active = builder.active;
    }

    public String hitTypeId() {
        return this.hitTypeId;
    }

    public NotificationSpecification notification() {
        return this.notification;
    }

    public Boolean active() {
        return this.active;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hitTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationSettingsRequest)) {
            return false;
        }
        UpdateNotificationSettingsRequest other = (UpdateNotificationSettingsRequest)((Object)obj);
        return Objects.equals(this.hitTypeId(), other.hitTypeId()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.active(), other.active());
    }

    public String toString() {
        return ToString.builder((String)"UpdateNotificationSettingsRequest").add("HITTypeId", (Object)this.hitTypeId()).add("Notification", (Object)this.notification()).add("Active", (Object)this.active()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITTypeId": {
                return Optional.ofNullable(clazz.cast(this.hitTypeId()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "Active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitTypeId;
        private NotificationSpecification notification;
        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationSettingsRequest model) {
            super(model);
            this.hitTypeId(model.hitTypeId);
            this.notification(model.notification);
            this.active(model.active);
        }

        public final String getHITTypeId() {
            return this.hitTypeId;
        }

        @Override
        public final Builder hitTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
            return this;
        }

        public final void setHITTypeId(String hitTypeId) {
            this.hitTypeId = hitTypeId;
        }

        public final NotificationSpecification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(NotificationSpecification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(NotificationSpecification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Boolean getActive() {
            return this.active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationSettingsRequest build() {
            return new UpdateNotificationSettingsRequest(this);
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    CopyableBuilder<Builder, UpdateNotificationSettingsRequest> {
        public Builder hitTypeId(String var1);

        public Builder notification(NotificationSpecification var1);

        default public Builder notification(Consumer<NotificationSpecification.Builder> notification) {
            return this.notification((NotificationSpecification)((NotificationSpecification.Builder)NotificationSpecification.builder().applyMutation(notification)).build());
        }

        public Builder active(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

