/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateExpirationForHitRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, UpdateExpirationForHitRequest> {
    private final String hitId;
    private final Instant expireAt;

    private UpdateExpirationForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.expireAt = builder.expireAt;
    }

    public String hitId() {
        return this.hitId;
    }

    public Instant expireAt() {
        return this.expireAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expireAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExpirationForHitRequest)) {
            return false;
        }
        UpdateExpirationForHitRequest other = (UpdateExpirationForHitRequest)((Object)obj);
        return Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.expireAt(), other.expireAt());
    }

    public String toString() {
        return ToString.builder((String)"UpdateExpirationForHitRequest").add("HITId", (Object)this.hitId()).add("ExpireAt", (Object)this.expireAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "ExpireAt": {
                return Optional.ofNullable(clazz.cast(this.expireAt()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitId;
        private Instant expireAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExpirationForHitRequest model) {
            super(model);
            this.hitId(model.hitId);
            this.expireAt(model.expireAt);
        }

        public final String getHITId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final Instant getExpireAt() {
            return this.expireAt;
        }

        @Override
        public final Builder expireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public final void setExpireAt(Instant expireAt) {
            this.expireAt = expireAt;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExpirationForHitRequest build() {
            return new UpdateExpirationForHitRequest(this);
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    CopyableBuilder<Builder, UpdateExpirationForHitRequest> {
        public Builder hitId(String var1);

        public Builder expireAt(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

