/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.PolicyParameter;
import software.amazon.awssdk.services.mturk.model.PolicyParameterListCopier;
import software.amazon.awssdk.services.mturk.transform.ReviewPolicyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, ReviewPolicy> {
    private final String policyName;
    private final List<PolicyParameter> parameters;

    private ReviewPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.parameters = builder.parameters;
    }

    public String policyName() {
        return this.policyName;
    }

    public List<PolicyParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewPolicy)) {
            return false;
        }
        ReviewPolicy other = (ReviewPolicy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"ReviewPolicy").add("PolicyName", (Object)this.policyName()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReviewPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private List<PolicyParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewPolicy model) {
            this.policyName(model.policyName);
            this.parameters(model.parameters);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final Collection<PolicyParameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(PolicyParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<PolicyParameter> parameters) {
            this.parameters = PolicyParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(PolicyParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<PolicyParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (PolicyParameter)((PolicyParameter.Builder)PolicyParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<PolicyParameter.BuilderImpl> parameters) {
            this.parameters = PolicyParameterListCopier.copyFromBuilder(parameters);
        }

        public ReviewPolicy build() {
            return new ReviewPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReviewPolicy> {
        public Builder policyName(String var1);

        public Builder parameters(Collection<PolicyParameter> var1);

        public Builder parameters(PolicyParameter ... var1);

        public Builder parameters(Consumer<PolicyParameter.Builder> ... var1);
    }
}

