/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.QualificationRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QualificationRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, QualificationRequest> {
    private final String qualificationRequestId;
    private final String qualificationTypeId;
    private final String workerId;
    private final String test;
    private final String answer;
    private final Instant submitTime;

    private QualificationRequest(BuilderImpl builder) {
        this.qualificationRequestId = builder.qualificationRequestId;
        this.qualificationTypeId = builder.qualificationTypeId;
        this.workerId = builder.workerId;
        this.test = builder.test;
        this.answer = builder.answer;
        this.submitTime = builder.submitTime;
    }

    public String qualificationRequestId() {
        return this.qualificationRequestId;
    }

    public String qualificationTypeId() {
        return this.qualificationTypeId;
    }

    public String workerId() {
        return this.workerId;
    }

    public String test() {
        return this.test;
    }

    public String answer() {
        return this.answer;
    }

    public Instant submitTime() {
        return this.submitTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        hashCode = 31 * hashCode + Objects.hashCode(this.answer());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QualificationRequest)) {
            return false;
        }
        QualificationRequest other = (QualificationRequest)obj;
        return Objects.equals(this.qualificationRequestId(), other.qualificationRequestId()) && Objects.equals(this.qualificationTypeId(), other.qualificationTypeId()) && Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.test(), other.test()) && Objects.equals(this.answer(), other.answer()) && Objects.equals(this.submitTime(), other.submitTime());
    }

    public String toString() {
        return ToString.builder((String)"QualificationRequest").add("QualificationRequestId", (Object)this.qualificationRequestId()).add("QualificationTypeId", (Object)this.qualificationTypeId()).add("WorkerId", (Object)this.workerId()).add("Test", (Object)this.test()).add("Answer", (Object)this.answer()).add("SubmitTime", (Object)this.submitTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QualificationRequestId": {
                return Optional.ofNullable(clazz.cast(this.qualificationRequestId()));
            }
            case "QualificationTypeId": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypeId()));
            }
            case "WorkerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "Test": {
                return Optional.ofNullable(clazz.cast(this.test()));
            }
            case "Answer": {
                return Optional.ofNullable(clazz.cast(this.answer()));
            }
            case "SubmitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QualificationRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String qualificationRequestId;
        private String qualificationTypeId;
        private String workerId;
        private String test;
        private String answer;
        private Instant submitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(QualificationRequest model) {
            this.qualificationRequestId(model.qualificationRequestId);
            this.qualificationTypeId(model.qualificationTypeId);
            this.workerId(model.workerId);
            this.test(model.test);
            this.answer(model.answer);
            this.submitTime(model.submitTime);
        }

        public final String getQualificationRequestId() {
            return this.qualificationRequestId;
        }

        @Override
        public final Builder qualificationRequestId(String qualificationRequestId) {
            this.qualificationRequestId = qualificationRequestId;
            return this;
        }

        public final void setQualificationRequestId(String qualificationRequestId) {
            this.qualificationRequestId = qualificationRequestId;
        }

        public final String getQualificationTypeId() {
            return this.qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final String getTest() {
            return this.test;
        }

        @Override
        public final Builder test(String test) {
            this.test = test;
            return this;
        }

        public final void setTest(String test) {
            this.test = test;
        }

        public final String getAnswer() {
            return this.answer;
        }

        @Override
        public final Builder answer(String answer) {
            this.answer = answer;
            return this;
        }

        public final void setAnswer(String answer) {
            this.answer = answer;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        public QualificationRequest build() {
            return new QualificationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QualificationRequest> {
        public Builder qualificationRequestId(String var1);

        public Builder qualificationTypeId(String var1);

        public Builder workerId(String var1);

        public Builder test(String var1);

        public Builder answer(String var1);

        public Builder submitTime(Instant var1);
    }
}

