/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.ParameterMapEntry;
import software.amazon.awssdk.services.mturk.model.ParameterMapEntryListCopier;
import software.amazon.awssdk.services.mturk.model.StringListCopier;
import software.amazon.awssdk.services.mturk.transform.PolicyParameterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyParameter
implements StructuredPojo,
ToCopyableBuilder<Builder, PolicyParameter> {
    private final String key;
    private final List<String> values;
    private final List<ParameterMapEntry> mapEntries;

    private PolicyParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.mapEntries = builder.mapEntries;
    }

    public String key() {
        return this.key;
    }

    public List<String> values() {
        return this.values;
    }

    public List<ParameterMapEntry> mapEntries() {
        return this.mapEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapEntries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyParameter)) {
            return false;
        }
        PolicyParameter other = (PolicyParameter)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.values(), other.values()) && Objects.equals(this.mapEntries(), other.mapEntries());
    }

    public String toString() {
        return ToString.builder((String)"PolicyParameter").add("Key", (Object)this.key()).add("Values", this.values()).add("MapEntries", this.mapEntries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "MapEntries": {
                return Optional.ofNullable(clazz.cast(this.mapEntries()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterMapEntry> mapEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyParameter model) {
            this.key(model.key);
            this.values(model.values);
            this.mapEntries(model.mapEntries);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = StringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = StringListCopier.copy(values);
        }

        public final Collection<ParameterMapEntry.Builder> getMapEntries() {
            return this.mapEntries != null ? (Collection)this.mapEntries.stream().map(ParameterMapEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapEntries(Collection<ParameterMapEntry> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copy(mapEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(ParameterMapEntry ... mapEntries) {
            this.mapEntries(Arrays.asList(mapEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapEntries(Consumer<ParameterMapEntry.Builder> ... mapEntries) {
            this.mapEntries(Stream.of(mapEntries).map(c -> (ParameterMapEntry)((ParameterMapEntry.Builder)ParameterMapEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMapEntries(Collection<ParameterMapEntry.BuilderImpl> mapEntries) {
            this.mapEntries = ParameterMapEntryListCopier.copyFromBuilder(mapEntries);
        }

        public PolicyParameter build() {
            return new PolicyParameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyParameter> {
        public Builder key(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder mapEntries(Collection<ParameterMapEntry> var1);

        public Builder mapEntries(ParameterMapEntry ... var1);

        public Builder mapEntries(Consumer<ParameterMapEntry.Builder> ... var1);
    }
}

