/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.services.mturk.model.ReviewPolicy;
import software.amazon.awssdk.services.mturk.model.ReviewReport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReviewPolicyResultsForHitResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListReviewPolicyResultsForHitResponse> {
    private final String hitId;
    private final ReviewPolicy assignmentReviewPolicy;
    private final ReviewPolicy hitReviewPolicy;
    private final ReviewReport assignmentReviewReport;
    private final ReviewReport hitReviewReport;
    private final String nextToken;

    private ListReviewPolicyResultsForHitResponse(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.assignmentReviewPolicy = builder.assignmentReviewPolicy;
        this.hitReviewPolicy = builder.hitReviewPolicy;
        this.assignmentReviewReport = builder.assignmentReviewReport;
        this.hitReviewReport = builder.hitReviewReport;
        this.nextToken = builder.nextToken;
    }

    public String hitId() {
        return this.hitId;
    }

    public ReviewPolicy assignmentReviewPolicy() {
        return this.assignmentReviewPolicy;
    }

    public ReviewPolicy hitReviewPolicy() {
        return this.hitReviewPolicy;
    }

    public ReviewReport assignmentReviewReport() {
        return this.assignmentReviewReport;
    }

    public ReviewReport hitReviewReport() {
        return this.hitReviewReport;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitReviewPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentReviewReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.hitReviewReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewPolicyResultsForHitResponse)) {
            return false;
        }
        ListReviewPolicyResultsForHitResponse other = (ListReviewPolicyResultsForHitResponse)((Object)obj);
        return Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.assignmentReviewPolicy(), other.assignmentReviewPolicy()) && Objects.equals(this.hitReviewPolicy(), other.hitReviewPolicy()) && Objects.equals(this.assignmentReviewReport(), other.assignmentReviewReport()) && Objects.equals(this.hitReviewReport(), other.hitReviewReport()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListReviewPolicyResultsForHitResponse").add("HITId", (Object)this.hitId()).add("AssignmentReviewPolicy", (Object)this.assignmentReviewPolicy()).add("HITReviewPolicy", (Object)this.hitReviewPolicy()).add("AssignmentReviewReport", (Object)this.assignmentReviewReport()).add("HITReviewReport", (Object)this.hitReviewReport()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "AssignmentReviewPolicy": {
                return Optional.ofNullable(clazz.cast(this.assignmentReviewPolicy()));
            }
            case "HITReviewPolicy": {
                return Optional.ofNullable(clazz.cast(this.hitReviewPolicy()));
            }
            case "AssignmentReviewReport": {
                return Optional.ofNullable(clazz.cast(this.assignmentReviewReport()));
            }
            case "HITReviewReport": {
                return Optional.ofNullable(clazz.cast(this.hitReviewReport()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private String hitId;
        private ReviewPolicy assignmentReviewPolicy;
        private ReviewPolicy hitReviewPolicy;
        private ReviewReport assignmentReviewReport;
        private ReviewReport hitReviewReport;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewPolicyResultsForHitResponse model) {
            super(model);
            this.hitId(model.hitId);
            this.assignmentReviewPolicy(model.assignmentReviewPolicy);
            this.hitReviewPolicy(model.hitReviewPolicy);
            this.assignmentReviewReport(model.assignmentReviewReport);
            this.hitReviewReport(model.hitReviewReport);
            this.nextToken(model.nextToken);
        }

        public final String getHITId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final ReviewPolicy.Builder getAssignmentReviewPolicy() {
            return this.assignmentReviewPolicy != null ? this.assignmentReviewPolicy.toBuilder() : null;
        }

        @Override
        public final Builder assignmentReviewPolicy(ReviewPolicy assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy;
            return this;
        }

        public final void setAssignmentReviewPolicy(ReviewPolicy.BuilderImpl assignmentReviewPolicy) {
            this.assignmentReviewPolicy = assignmentReviewPolicy != null ? assignmentReviewPolicy.build() : null;
        }

        public final ReviewPolicy.Builder getHITReviewPolicy() {
            return this.hitReviewPolicy != null ? this.hitReviewPolicy.toBuilder() : null;
        }

        @Override
        public final Builder hitReviewPolicy(ReviewPolicy hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy;
            return this;
        }

        public final void setHITReviewPolicy(ReviewPolicy.BuilderImpl hitReviewPolicy) {
            this.hitReviewPolicy = hitReviewPolicy != null ? hitReviewPolicy.build() : null;
        }

        public final ReviewReport.Builder getAssignmentReviewReport() {
            return this.assignmentReviewReport != null ? this.assignmentReviewReport.toBuilder() : null;
        }

        @Override
        public final Builder assignmentReviewReport(ReviewReport assignmentReviewReport) {
            this.assignmentReviewReport = assignmentReviewReport;
            return this;
        }

        public final void setAssignmentReviewReport(ReviewReport.BuilderImpl assignmentReviewReport) {
            this.assignmentReviewReport = assignmentReviewReport != null ? assignmentReviewReport.build() : null;
        }

        public final ReviewReport.Builder getHITReviewReport() {
            return this.hitReviewReport != null ? this.hitReviewReport.toBuilder() : null;
        }

        @Override
        public final Builder hitReviewReport(ReviewReport hitReviewReport) {
            this.hitReviewReport = hitReviewReport;
            return this;
        }

        public final void setHITReviewReport(ReviewReport.BuilderImpl hitReviewReport) {
            this.hitReviewReport = hitReviewReport != null ? hitReviewReport.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListReviewPolicyResultsForHitResponse build() {
            return new ListReviewPolicyResultsForHitResponse(this);
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    CopyableBuilder<Builder, ListReviewPolicyResultsForHitResponse> {
        public Builder hitId(String var1);

        public Builder assignmentReviewPolicy(ReviewPolicy var1);

        default public Builder assignmentReviewPolicy(Consumer<ReviewPolicy.Builder> assignmentReviewPolicy) {
            return this.assignmentReviewPolicy((ReviewPolicy)((ReviewPolicy.Builder)ReviewPolicy.builder().applyMutation(assignmentReviewPolicy)).build());
        }

        public Builder hitReviewPolicy(ReviewPolicy var1);

        default public Builder hitReviewPolicy(Consumer<ReviewPolicy.Builder> hitReviewPolicy) {
            return this.hitReviewPolicy((ReviewPolicy)((ReviewPolicy.Builder)ReviewPolicy.builder().applyMutation(hitReviewPolicy)).build());
        }

        public Builder assignmentReviewReport(ReviewReport var1);

        default public Builder assignmentReviewReport(Consumer<ReviewReport.Builder> assignmentReviewReport) {
            return this.assignmentReviewReport((ReviewReport)((ReviewReport.Builder)ReviewReport.builder().applyMutation(assignmentReviewReport)).build());
        }

        public Builder hitReviewReport(ReviewReport var1);

        default public Builder hitReviewReport(Consumer<ReviewReport.Builder> hitReviewReport) {
            return this.hitReviewReport((ReviewReport)((ReviewReport.Builder)ReviewReport.builder().applyMutation(hitReviewReport)).build());
        }

        public Builder nextToken(String var1);
    }
}

