/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.services.mturk.model.QualificationType;
import software.amazon.awssdk.services.mturk.model.QualificationTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQualificationTypesResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListQualificationTypesResponse> {
    private final Integer numResults;
    private final String nextToken;
    private final List<QualificationType> qualificationTypes;

    private ListQualificationTypesResponse(BuilderImpl builder) {
        super(builder);
        this.numResults = builder.numResults;
        this.nextToken = builder.nextToken;
        this.qualificationTypes = builder.qualificationTypes;
    }

    public Integer numResults() {
        return this.numResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<QualificationType> qualificationTypes() {
        return this.qualificationTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQualificationTypesResponse)) {
            return false;
        }
        ListQualificationTypesResponse other = (ListQualificationTypesResponse)((Object)obj);
        return Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.qualificationTypes(), other.qualificationTypes());
    }

    public String toString() {
        return ToString.builder((String)"ListQualificationTypesResponse").add("NumResults", (Object)this.numResults()).add("NextToken", (Object)this.nextToken()).add("QualificationTypes", this.qualificationTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "QualificationTypes": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private Integer numResults;
        private String nextToken;
        private List<QualificationType> qualificationTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQualificationTypesResponse model) {
            super(model);
            this.numResults(model.numResults);
            this.nextToken(model.nextToken);
            this.qualificationTypes(model.qualificationTypes);
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<QualificationType.Builder> getQualificationTypes() {
            return this.qualificationTypes != null ? (Collection)this.qualificationTypes.stream().map(QualificationType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder qualificationTypes(Collection<QualificationType> qualificationTypes) {
            this.qualificationTypes = QualificationTypeListCopier.copy(qualificationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationTypes(QualificationType ... qualificationTypes) {
            this.qualificationTypes(Arrays.asList(qualificationTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualificationTypes(Consumer<QualificationType.Builder> ... qualificationTypes) {
            this.qualificationTypes(Stream.of(qualificationTypes).map(c -> (QualificationType)((QualificationType.Builder)QualificationType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQualificationTypes(Collection<QualificationType.BuilderImpl> qualificationTypes) {
            this.qualificationTypes = QualificationTypeListCopier.copyFromBuilder(qualificationTypes);
        }

        @Override
        public ListQualificationTypesResponse build() {
            return new ListQualificationTypesResponse(this);
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    CopyableBuilder<Builder, ListQualificationTypesResponse> {
        public Builder numResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder qualificationTypes(Collection<QualificationType> var1);

        public Builder qualificationTypes(QualificationType ... var1);

        public Builder qualificationTypes(Consumer<QualificationType.Builder> ... var1);
    }
}

