/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQualificationTypesRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, ListQualificationTypesRequest> {
    private final String query;
    private final Boolean mustBeRequestable;
    private final Boolean mustBeOwnedByCaller;
    private final String nextToken;
    private final Integer maxResults;

    private ListQualificationTypesRequest(BuilderImpl builder) {
        super(builder);
        this.query = builder.query;
        this.mustBeRequestable = builder.mustBeRequestable;
        this.mustBeOwnedByCaller = builder.mustBeOwnedByCaller;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String query() {
        return this.query;
    }

    public Boolean mustBeRequestable() {
        return this.mustBeRequestable;
    }

    public Boolean mustBeOwnedByCaller() {
        return this.mustBeOwnedByCaller;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.mustBeRequestable());
        hashCode = 31 * hashCode + Objects.hashCode(this.mustBeOwnedByCaller());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQualificationTypesRequest)) {
            return false;
        }
        ListQualificationTypesRequest other = (ListQualificationTypesRequest)((Object)obj);
        return Objects.equals(this.query(), other.query()) && Objects.equals(this.mustBeRequestable(), other.mustBeRequestable()) && Objects.equals(this.mustBeOwnedByCaller(), other.mustBeOwnedByCaller()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListQualificationTypesRequest").add("Query", (Object)this.query()).add("MustBeRequestable", (Object)this.mustBeRequestable()).add("MustBeOwnedByCaller", (Object)this.mustBeOwnedByCaller()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "MustBeRequestable": {
                return Optional.ofNullable(clazz.cast(this.mustBeRequestable()));
            }
            case "MustBeOwnedByCaller": {
                return Optional.ofNullable(clazz.cast(this.mustBeOwnedByCaller()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String query;
        private Boolean mustBeRequestable;
        private Boolean mustBeOwnedByCaller;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQualificationTypesRequest model) {
            super(model);
            this.query(model.query);
            this.mustBeRequestable(model.mustBeRequestable);
            this.mustBeOwnedByCaller(model.mustBeOwnedByCaller);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final Boolean getMustBeRequestable() {
            return this.mustBeRequestable;
        }

        @Override
        public final Builder mustBeRequestable(Boolean mustBeRequestable) {
            this.mustBeRequestable = mustBeRequestable;
            return this;
        }

        public final void setMustBeRequestable(Boolean mustBeRequestable) {
            this.mustBeRequestable = mustBeRequestable;
        }

        public final Boolean getMustBeOwnedByCaller() {
            return this.mustBeOwnedByCaller;
        }

        @Override
        public final Builder mustBeOwnedByCaller(Boolean mustBeOwnedByCaller) {
            this.mustBeOwnedByCaller = mustBeOwnedByCaller;
            return this;
        }

        public final void setMustBeOwnedByCaller(Boolean mustBeOwnedByCaller) {
            this.mustBeOwnedByCaller = mustBeOwnedByCaller;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQualificationTypesRequest build() {
            return new ListQualificationTypesRequest(this);
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    CopyableBuilder<Builder, ListQualificationTypesRequest> {
        public Builder query(String var1);

        public Builder mustBeRequestable(Boolean var1);

        public Builder mustBeOwnedByCaller(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

