/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.QualificationTypeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQualificationTypeRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, CreateQualificationTypeRequest> {
    private final String name;
    private final String keywords;
    private final String description;
    private final String qualificationTypeStatus;
    private final Long retryDelayInSeconds;
    private final String test;
    private final String answerKey;
    private final Long testDurationInSeconds;
    private final Boolean autoGranted;
    private final Integer autoGrantedValue;

    private CreateQualificationTypeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.keywords = builder.keywords;
        this.description = builder.description;
        this.qualificationTypeStatus = builder.qualificationTypeStatus;
        this.retryDelayInSeconds = builder.retryDelayInSeconds;
        this.test = builder.test;
        this.answerKey = builder.answerKey;
        this.testDurationInSeconds = builder.testDurationInSeconds;
        this.autoGranted = builder.autoGranted;
        this.autoGrantedValue = builder.autoGrantedValue;
    }

    public String name() {
        return this.name;
    }

    public String keywords() {
        return this.keywords;
    }

    public String description() {
        return this.description;
    }

    public QualificationTypeStatus qualificationTypeStatus() {
        return QualificationTypeStatus.fromValue(this.qualificationTypeStatus);
    }

    public String qualificationTypeStatusAsString() {
        return this.qualificationTypeStatus;
    }

    public Long retryDelayInSeconds() {
        return this.retryDelayInSeconds;
    }

    public String test() {
        return this.test;
    }

    public String answerKey() {
        return this.answerKey;
    }

    public Long testDurationInSeconds() {
        return this.testDurationInSeconds;
    }

    public Boolean autoGranted() {
        return this.autoGranted;
    }

    public Integer autoGrantedValue() {
        return this.autoGrantedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.keywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationTypeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        hashCode = 31 * hashCode + Objects.hashCode(this.answerKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.testDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoGranted());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoGrantedValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQualificationTypeRequest)) {
            return false;
        }
        CreateQualificationTypeRequest other = (CreateQualificationTypeRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.qualificationTypeStatusAsString(), other.qualificationTypeStatusAsString()) && Objects.equals(this.retryDelayInSeconds(), other.retryDelayInSeconds()) && Objects.equals(this.test(), other.test()) && Objects.equals(this.answerKey(), other.answerKey()) && Objects.equals(this.testDurationInSeconds(), other.testDurationInSeconds()) && Objects.equals(this.autoGranted(), other.autoGranted()) && Objects.equals(this.autoGrantedValue(), other.autoGrantedValue());
    }

    public String toString() {
        return ToString.builder((String)"CreateQualificationTypeRequest").add("Name", (Object)this.name()).add("Keywords", (Object)this.keywords()).add("Description", (Object)this.description()).add("QualificationTypeStatus", (Object)this.qualificationTypeStatusAsString()).add("RetryDelayInSeconds", (Object)this.retryDelayInSeconds()).add("Test", (Object)this.test()).add("AnswerKey", (Object)this.answerKey()).add("TestDurationInSeconds", (Object)this.testDurationInSeconds()).add("AutoGranted", (Object)this.autoGranted()).add("AutoGrantedValue", (Object)this.autoGrantedValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "QualificationTypeStatus": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypeStatusAsString()));
            }
            case "RetryDelayInSeconds": {
                return Optional.ofNullable(clazz.cast(this.retryDelayInSeconds()));
            }
            case "Test": {
                return Optional.ofNullable(clazz.cast(this.test()));
            }
            case "AnswerKey": {
                return Optional.ofNullable(clazz.cast(this.answerKey()));
            }
            case "TestDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.testDurationInSeconds()));
            }
            case "AutoGranted": {
                return Optional.ofNullable(clazz.cast(this.autoGranted()));
            }
            case "AutoGrantedValue": {
                return Optional.ofNullable(clazz.cast(this.autoGrantedValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String name;
        private String keywords;
        private String description;
        private String qualificationTypeStatus;
        private Long retryDelayInSeconds;
        private String test;
        private String answerKey;
        private Long testDurationInSeconds;
        private Boolean autoGranted;
        private Integer autoGrantedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQualificationTypeRequest model) {
            super(model);
            this.name(model.name);
            this.keywords(model.keywords);
            this.description(model.description);
            this.qualificationTypeStatus(model.qualificationTypeStatus);
            this.retryDelayInSeconds(model.retryDelayInSeconds);
            this.test(model.test);
            this.answerKey(model.answerKey);
            this.testDurationInSeconds(model.testDurationInSeconds);
            this.autoGranted(model.autoGranted);
            this.autoGrantedValue(model.autoGrantedValue);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getKeywords() {
            return this.keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getQualificationTypeStatus() {
            return this.qualificationTypeStatus;
        }

        @Override
        public final Builder qualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
            return this;
        }

        @Override
        public final Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus) {
            this.qualificationTypeStatus(qualificationTypeStatus.toString());
            return this;
        }

        public final void setQualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
        }

        public final Long getRetryDelayInSeconds() {
            return this.retryDelayInSeconds;
        }

        @Override
        public final Builder retryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
            return this;
        }

        public final void setRetryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
        }

        public final String getTest() {
            return this.test;
        }

        @Override
        public final Builder test(String test) {
            this.test = test;
            return this;
        }

        public final void setTest(String test) {
            this.test = test;
        }

        public final String getAnswerKey() {
            return this.answerKey;
        }

        @Override
        public final Builder answerKey(String answerKey) {
            this.answerKey = answerKey;
            return this;
        }

        public final void setAnswerKey(String answerKey) {
            this.answerKey = answerKey;
        }

        public final Long getTestDurationInSeconds() {
            return this.testDurationInSeconds;
        }

        @Override
        public final Builder testDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
            return this;
        }

        public final void setTestDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
        }

        public final Boolean getAutoGranted() {
            return this.autoGranted;
        }

        @Override
        public final Builder autoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
            return this;
        }

        public final void setAutoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
        }

        public final Integer getAutoGrantedValue() {
            return this.autoGrantedValue;
        }

        @Override
        public final Builder autoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
            return this;
        }

        public final void setAutoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQualificationTypeRequest build() {
            return new CreateQualificationTypeRequest(this);
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    CopyableBuilder<Builder, CreateQualificationTypeRequest> {
        public Builder name(String var1);

        public Builder keywords(String var1);

        public Builder description(String var1);

        public Builder qualificationTypeStatus(String var1);

        public Builder qualificationTypeStatus(QualificationTypeStatus var1);

        public Builder retryDelayInSeconds(Long var1);

        public Builder test(String var1);

        public Builder answerKey(String var1);

        public Builder testDurationInSeconds(Long var1);

        public Builder autoGranted(Boolean var1);

        public Builder autoGrantedValue(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

