/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAdditionalAssignmentsForHitRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, CreateAdditionalAssignmentsForHitRequest> {
    private final String hitId;
    private final Integer numberOfAdditionalAssignments;
    private final String uniqueRequestToken;

    private CreateAdditionalAssignmentsForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.numberOfAdditionalAssignments = builder.numberOfAdditionalAssignments;
        this.uniqueRequestToken = builder.uniqueRequestToken;
    }

    public String hitId() {
        return this.hitId;
    }

    public Integer numberOfAdditionalAssignments() {
        return this.numberOfAdditionalAssignments;
    }

    public String uniqueRequestToken() {
        return this.uniqueRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAdditionalAssignments());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAdditionalAssignmentsForHitRequest)) {
            return false;
        }
        CreateAdditionalAssignmentsForHitRequest other = (CreateAdditionalAssignmentsForHitRequest)((Object)obj);
        return Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.numberOfAdditionalAssignments(), other.numberOfAdditionalAssignments()) && Objects.equals(this.uniqueRequestToken(), other.uniqueRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateAdditionalAssignmentsForHitRequest").add("HITId", (Object)this.hitId()).add("NumberOfAdditionalAssignments", (Object)this.numberOfAdditionalAssignments()).add("UniqueRequestToken", (Object)this.uniqueRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "NumberOfAdditionalAssignments": {
                return Optional.ofNullable(clazz.cast(this.numberOfAdditionalAssignments()));
            }
            case "UniqueRequestToken": {
                return Optional.ofNullable(clazz.cast(this.uniqueRequestToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitId;
        private Integer numberOfAdditionalAssignments;
        private String uniqueRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAdditionalAssignmentsForHitRequest model) {
            super(model);
            this.hitId(model.hitId);
            this.numberOfAdditionalAssignments(model.numberOfAdditionalAssignments);
            this.uniqueRequestToken(model.uniqueRequestToken);
        }

        public final String getHITId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final Integer getNumberOfAdditionalAssignments() {
            return this.numberOfAdditionalAssignments;
        }

        @Override
        public final Builder numberOfAdditionalAssignments(Integer numberOfAdditionalAssignments) {
            this.numberOfAdditionalAssignments = numberOfAdditionalAssignments;
            return this;
        }

        public final void setNumberOfAdditionalAssignments(Integer numberOfAdditionalAssignments) {
            this.numberOfAdditionalAssignments = numberOfAdditionalAssignments;
        }

        public final String getUniqueRequestToken() {
            return this.uniqueRequestToken;
        }

        @Override
        public final Builder uniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
            return this;
        }

        public final void setUniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAdditionalAssignmentsForHitRequest build() {
            return new CreateAdditionalAssignmentsForHitRequest(this);
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    CopyableBuilder<Builder, CreateAdditionalAssignmentsForHitRequest> {
        public Builder hitId(String var1);

        public Builder numberOfAdditionalAssignments(Integer var1);

        public Builder uniqueRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

