/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mturk.transform.BonusPaymentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BonusPayment
implements StructuredPojo,
ToCopyableBuilder<Builder, BonusPayment> {
    private final String workerId;
    private final String bonusAmount;
    private final String assignmentId;
    private final String reason;
    private final Instant grantTime;

    private BonusPayment(BuilderImpl builder) {
        this.workerId = builder.workerId;
        this.bonusAmount = builder.bonusAmount;
        this.assignmentId = builder.assignmentId;
        this.reason = builder.reason;
        this.grantTime = builder.grantTime;
    }

    public String workerId() {
        return this.workerId;
    }

    public String bonusAmount() {
        return this.bonusAmount;
    }

    public String assignmentId() {
        return this.assignmentId;
    }

    public String reason() {
        return this.reason;
    }

    public Instant grantTime() {
        return this.grantTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bonusAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BonusPayment)) {
            return false;
        }
        BonusPayment other = (BonusPayment)obj;
        return Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.bonusAmount(), other.bonusAmount()) && Objects.equals(this.assignmentId(), other.assignmentId()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.grantTime(), other.grantTime());
    }

    public String toString() {
        return ToString.builder((String)"BonusPayment").add("WorkerId", (Object)this.workerId()).add("BonusAmount", (Object)this.bonusAmount()).add("AssignmentId", (Object)this.assignmentId()).add("Reason", (Object)this.reason()).add("GrantTime", (Object)this.grantTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "BonusAmount": {
                return Optional.ofNullable(clazz.cast(this.bonusAmount()));
            }
            case "AssignmentId": {
                return Optional.ofNullable(clazz.cast(this.assignmentId()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "GrantTime": {
                return Optional.ofNullable(clazz.cast(this.grantTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BonusPaymentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String workerId;
        private String bonusAmount;
        private String assignmentId;
        private String reason;
        private Instant grantTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BonusPayment model) {
            this.workerId(model.workerId);
            this.bonusAmount(model.bonusAmount);
            this.assignmentId(model.assignmentId);
            this.reason(model.reason);
            this.grantTime(model.grantTime);
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final String getBonusAmount() {
            return this.bonusAmount;
        }

        @Override
        public final Builder bonusAmount(String bonusAmount) {
            this.bonusAmount = bonusAmount;
            return this;
        }

        public final void setBonusAmount(String bonusAmount) {
            this.bonusAmount = bonusAmount;
        }

        public final String getAssignmentId() {
            return this.assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Instant getGrantTime() {
            return this.grantTime;
        }

        @Override
        public final Builder grantTime(Instant grantTime) {
            this.grantTime = grantTime;
            return this;
        }

        public final void setGrantTime(Instant grantTime) {
            this.grantTime = grantTime;
        }

        public BonusPayment build() {
            return new BonusPayment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BonusPayment> {
        public Builder workerId(String var1);

        public Builder bonusAmount(String var1);

        public Builder assignmentId(String var1);

        public Builder reason(String var1);

        public Builder grantTime(Instant var1);
    }
}

