/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mq.MqAsyncClient;
import software.amazon.awssdk.services.mq.model.BrokerSummary;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;
import software.amazon.awssdk.services.mq.model.ListBrokersResponse;

public class ListBrokersPublisher
implements SdkPublisher<ListBrokersResponse> {
    private final MqAsyncClient client;
    private final ListBrokersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBrokersPublisher(MqAsyncClient client, ListBrokersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBrokersPublisher(MqAsyncClient client, ListBrokersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBrokersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBrokersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BrokerSummary> brokerSummaries() {
        Function<ListBrokersResponse, Iterator> getIterator = response -> {
            if (response != null && response.brokerSummaries() != null) {
                return response.brokerSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBrokersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBrokersResponseFetcher
    implements AsyncPageFetcher<ListBrokersResponse> {
        private ListBrokersResponseFetcher() {
        }

        public boolean hasNextPage(ListBrokersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBrokersResponse> nextPage(ListBrokersResponse previousPage) {
            if (previousPage == null) {
                return ListBrokersPublisher.this.client.listBrokers(ListBrokersPublisher.this.firstRequest);
            }
            return ListBrokersPublisher.this.client.listBrokers((ListBrokersRequest)((Object)ListBrokersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

