/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.mq.MqClient;
import software.amazon.awssdk.services.mq.model.BadRequestException;
import software.amazon.awssdk.services.mq.model.ConflictException;
import software.amazon.awssdk.services.mq.model.CreateBrokerRequest;
import software.amazon.awssdk.services.mq.model.CreateBrokerResponse;
import software.amazon.awssdk.services.mq.model.CreateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.CreateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.CreateTagsRequest;
import software.amazon.awssdk.services.mq.model.CreateTagsResponse;
import software.amazon.awssdk.services.mq.model.CreateUserRequest;
import software.amazon.awssdk.services.mq.model.CreateUserResponse;
import software.amazon.awssdk.services.mq.model.DeleteBrokerRequest;
import software.amazon.awssdk.services.mq.model.DeleteBrokerResponse;
import software.amazon.awssdk.services.mq.model.DeleteTagsRequest;
import software.amazon.awssdk.services.mq.model.DeleteTagsResponse;
import software.amazon.awssdk.services.mq.model.DeleteUserRequest;
import software.amazon.awssdk.services.mq.model.DeleteUserResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerEngineTypesRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerEngineTypesResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerInstanceOptionsRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerInstanceOptionsResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionResponse;
import software.amazon.awssdk.services.mq.model.DescribeUserRequest;
import software.amazon.awssdk.services.mq.model.DescribeUserResponse;
import software.amazon.awssdk.services.mq.model.ForbiddenException;
import software.amazon.awssdk.services.mq.model.InternalServerErrorException;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;
import software.amazon.awssdk.services.mq.model.ListBrokersResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.mq.model.ListTagsRequest;
import software.amazon.awssdk.services.mq.model.ListTagsResponse;
import software.amazon.awssdk.services.mq.model.ListUsersRequest;
import software.amazon.awssdk.services.mq.model.ListUsersResponse;
import software.amazon.awssdk.services.mq.model.MqException;
import software.amazon.awssdk.services.mq.model.MqRequest;
import software.amazon.awssdk.services.mq.model.NotFoundException;
import software.amazon.awssdk.services.mq.model.RebootBrokerRequest;
import software.amazon.awssdk.services.mq.model.RebootBrokerResponse;
import software.amazon.awssdk.services.mq.model.UnauthorizedException;
import software.amazon.awssdk.services.mq.model.UpdateBrokerRequest;
import software.amazon.awssdk.services.mq.model.UpdateBrokerResponse;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.UpdateUserRequest;
import software.amazon.awssdk.services.mq.model.UpdateUserResponse;
import software.amazon.awssdk.services.mq.paginators.ListBrokersIterable;
import software.amazon.awssdk.services.mq.transform.CreateBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.CreateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DeleteBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeBrokerEngineTypesRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeBrokerInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeConfigurationRevisionRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.ListBrokersRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.ListConfigurationRevisionsRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.ListConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.RebootBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.UpdateBrokerRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.UpdateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mq.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMqClient
implements MqClient {
    private static final Logger log = Logger.loggerFor(DefaultMqClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMqClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "mq";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBrokerResponse createBroker(CreateBrokerRequest createBrokerRequest) throws BadRequestException, UnauthorizedException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBrokerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, createBrokerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBroker");
            CreateBrokerResponse createBrokerResponse = (CreateBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBroker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBrokerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBrokerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBrokerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$createBroker$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationResponse createConfiguration(CreateConfigurationRequest createConfigurationRequest) throws BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, createConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfiguration");
            CreateConfigurationResponse createConfigurationResponse = (CreateConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$createConfiguration$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, createTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTags");
            CreateTagsResponse createTagsResponse = (CreateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$createTags$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, createUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUser");
            CreateUserResponse createUserResponse = (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$createUser$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBrokerResponse deleteBroker(DeleteBrokerRequest deleteBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBrokerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, deleteBrokerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBroker");
            DeleteBrokerResponse deleteBrokerResponse = (DeleteBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBroker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBrokerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBrokerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBrokerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$deleteBroker$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            DeleteTagsResponse deleteTagsResponse = (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$deleteTags$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, deleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUser");
            DeleteUserResponse deleteUserResponse = (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$deleteUser$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBrokerResponse describeBroker(DescribeBrokerRequest describeBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBrokerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, describeBrokerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBroker");
            DescribeBrokerResponse describeBrokerResponse = (DescribeBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBroker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBrokerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBrokerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBrokerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$describeBroker$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBrokerEngineTypesResponse describeBrokerEngineTypes(DescribeBrokerEngineTypesRequest describeBrokerEngineTypesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBrokerEngineTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, describeBrokerEngineTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBrokerEngineTypes");
            DescribeBrokerEngineTypesResponse describeBrokerEngineTypesResponse = (DescribeBrokerEngineTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBrokerEngineTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBrokerEngineTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBrokerEngineTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBrokerEngineTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$describeBrokerEngineTypes$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBrokerInstanceOptionsResponse describeBrokerInstanceOptions(DescribeBrokerInstanceOptionsRequest describeBrokerInstanceOptionsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBrokerInstanceOptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, describeBrokerInstanceOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBrokerInstanceOptions");
            DescribeBrokerInstanceOptionsResponse describeBrokerInstanceOptionsResponse = (DescribeBrokerInstanceOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBrokerInstanceOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBrokerInstanceOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBrokerInstanceOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBrokerInstanceOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$describeBrokerInstanceOptions$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationResponse describeConfiguration(DescribeConfigurationRequest describeConfigurationRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, describeConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfiguration");
            DescribeConfigurationResponse describeConfigurationResponse = (DescribeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$describeConfiguration$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationRevisionResponse describeConfigurationRevision(DescribeConfigurationRevisionRequest describeConfigurationRevisionRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationRevisionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, describeConfigurationRevisionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationRevision");
            DescribeConfigurationRevisionResponse describeConfigurationRevisionResponse = (DescribeConfigurationRevisionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationRevision").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeConfigurationRevisionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigurationRevisionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConfigurationRevisionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$describeConfigurationRevision$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, describeUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUser");
            DescribeUserResponse describeUserResponse = (DescribeUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$describeUser$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBrokersResponse listBrokers(ListBrokersRequest listBrokersRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBrokersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, listBrokersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBrokers");
            ListBrokersResponse listBrokersResponse = (ListBrokersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBrokers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBrokersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBrokersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBrokersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$listBrokers$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBrokersIterable listBrokersPaginator(ListBrokersRequest listBrokersRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        return new ListBrokersIterable(this, this.applyPaginatorUserAgent(listBrokersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigurationRevisionsResponse listConfigurationRevisions(ListConfigurationRevisionsRequest listConfigurationRevisionsRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfigurationRevisionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, listConfigurationRevisionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConfigurationRevisions");
            ListConfigurationRevisionsResponse listConfigurationRevisionsResponse = (ListConfigurationRevisionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurationRevisions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConfigurationRevisionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConfigurationRevisionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConfigurationRevisionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$listConfigurationRevisions$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigurationsResponse listConfigurations(ListConfigurationsRequest listConfigurationsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfigurationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, listConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConfigurations");
            ListConfigurationsResponse listConfigurationsResponse = (ListConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$listConfigurations$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            ListTagsResponse listTagsResponse = (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$listTags$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, listUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListUsers");
            ListUsersResponse listUsersResponse = (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listUsersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$listUsers$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootBrokerResponse rebootBroker(RebootBrokerRequest rebootBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootBrokerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, rebootBrokerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootBroker");
            RebootBrokerResponse rebootBrokerResponse = (RebootBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootBroker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootBrokerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootBrokerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rebootBrokerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$rebootBroker$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBrokerResponse updateBroker(UpdateBrokerRequest updateBrokerRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBrokerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, updateBrokerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBroker");
            UpdateBrokerResponse updateBrokerResponse = (UpdateBrokerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBroker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBrokerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBrokerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBrokerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$updateBroker$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationResponse updateConfiguration(UpdateConfigurationRequest updateConfigurationRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, updateConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfiguration");
            UpdateConfigurationResponse updateConfigurationResponse = (UpdateConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$updateConfiguration$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ConflictException, ForbiddenException, AwsServiceException, SdkClientException, MqException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMqClient.resolveMetricPublishers(this.clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mq");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            UpdateUserResponse updateUserResponse = (UpdateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateUserResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMqClient.lambda$updateUser$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MqException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ForbiddenException").exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerErrorException").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends MqRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.212").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MqRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateUser$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateConfiguration$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBroker$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootBroker$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listUsers$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConfigurations$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConfigurationRevisions$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBrokers$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUser$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConfigurationRevision$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConfiguration$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBrokerInstanceOptions$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBrokerEngineTypes$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBroker$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUser$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTags$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBroker$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUser$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTags$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfiguration$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBroker$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

