/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrokerResponse extends MqResponse implements
        ToCopyableBuilder<UpdateBrokerResponse.Builder, UpdateBrokerResponse> {
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateBrokerResponse::autoMinorVersionUpgrade)).setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> BROKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateBrokerResponse::brokerId)).setter(setter(Builder::brokerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()).build();

    private static final SdkField<ConfigurationId> CONFIGURATION_FIELD = SdkField
            .<ConfigurationId> builder(MarshallingType.SDK_POJO).getter(getter(UpdateBrokerResponse::configuration))
            .setter(setter(Builder::configuration)).constructor(ConfigurationId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateBrokerResponse::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateBrokerResponse::hostInstanceType)).setter(setter(Builder::hostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()).build();

    private static final SdkField<Logs> LOGS_FIELD = SdkField.<Logs> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateBrokerResponse::logs)).setter(setter(Builder::logs)).constructor(Logs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateBrokerResponse::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_ID_FIELD, CONFIGURATION_FIELD, ENGINE_VERSION_FIELD,
            HOST_INSTANCE_TYPE_FIELD, LOGS_FIELD, SECURITY_GROUPS_FIELD));

    private final Boolean autoMinorVersionUpgrade;

    private final String brokerId;

    private final ConfigurationId configuration;

    private final String engineVersion;

    private final String hostInstanceType;

    private final Logs logs;

    private final List<String> securityGroups;

    private UpdateBrokerResponse(BuilderImpl builder) {
        super(builder);
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerId = builder.brokerId;
        this.configuration = builder.configuration;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.logs = builder.logs;
        this.securityGroups = builder.securityGroups;
    }

    /**
     * The new value of automatic upgrades to new minor version for brokers.
     * 
     * @return The new value of automatic upgrades to new minor version for brokers.
     */
    public Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * Required. The unique ID that Amazon MQ generates for the broker.
     * 
     * @return Required. The unique ID that Amazon MQ generates for the broker.
     */
    public String brokerId() {
        return brokerId;
    }

    /**
     * The ID of the updated configuration.
     * 
     * @return The ID of the updated configuration.
     */
    public ConfigurationId configuration() {
        return configuration;
    }

    /**
     * The version of the broker engine to upgrade to. For a list of supported engine versions, see
     * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
     * 
     * @return The version of the broker engine to upgrade to. For a list of supported engine versions, see
     *         https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * The host instance type of the broker to upgrade to. For a list of supported instance types, see
     * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide//broker.html#broker-instance-types
     * 
     * @return The host instance type of the broker to upgrade to. For a list of supported instance types, see
     *         https://docs.aws.amazon.com/amazon-mq/latest/developer-guide//broker.html#broker-instance-types
     */
    public String hostInstanceType() {
        return hostInstanceType;
    }

    /**
     * The list of information about logs to be enabled for the specified broker.
     * 
     * @return The list of information about logs to be enabled for the specified broker.
     */
    public Logs logs() {
        return logs;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(logs());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerResponse)) {
            return false;
        }
        UpdateBrokerResponse other = (UpdateBrokerResponse) obj;
        return Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(brokerId(), other.brokerId()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(hostInstanceType(), other.hostInstanceType()) && Objects.equals(logs(), other.logs())
                && Objects.equals(securityGroups(), other.securityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateBrokerResponse").add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("BrokerId", brokerId()).add("Configuration", configuration()).add("EngineVersion", engineVersion())
                .add("HostInstanceType", hostInstanceType()).add("Logs", logs()).add("SecurityGroups", securityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "BrokerId":
            return Optional.ofNullable(clazz.cast(brokerId()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "HostInstanceType":
            return Optional.ofNullable(clazz.cast(hostInstanceType()));
        case "Logs":
            return Optional.ofNullable(clazz.cast(logs()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerResponse, T> g) {
        return obj -> g.apply((UpdateBrokerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBrokerResponse> {
        /**
         * The new value of automatic upgrades to new minor version for brokers.
         * 
         * @param autoMinorVersionUpgrade
         *        The new value of automatic upgrades to new minor version for brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * Required. The unique ID that Amazon MQ generates for the broker.
         * 
         * @param brokerId
         *        Required. The unique ID that Amazon MQ generates for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerId(String brokerId);

        /**
         * The ID of the updated configuration.
         * 
         * @param configuration
         *        The ID of the updated configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ConfigurationId configuration);

        /**
         * The ID of the updated configuration. This is a convenience that creates an instance of the
         * {@link ConfigurationId.Builder} avoiding the need to create one manually via
         * {@link ConfigurationId#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationId.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(ConfigurationId)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ConfigurationId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ConfigurationId)
         */
        default Builder configuration(Consumer<ConfigurationId.Builder> configuration) {
            return configuration(ConfigurationId.builder().applyMutation(configuration).build());
        }

        /**
         * The version of the broker engine to upgrade to. For a list of supported engine versions, see
         * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
         * 
         * @param engineVersion
         *        The version of the broker engine to upgrade to. For a list of supported engine versions, see
         *        https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * The host instance type of the broker to upgrade to. For a list of supported instance types, see
         * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide//broker.html#broker-instance-types
         * 
         * @param hostInstanceType
         *        The host instance type of the broker to upgrade to. For a list of supported instance types, see
         *        https://docs.aws.amazon.com/amazon-mq/latest/developer-guide//broker.html#broker-instance-types
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostInstanceType(String hostInstanceType);

        /**
         * The list of information about logs to be enabled for the specified broker.
         * 
         * @param logs
         *        The list of information about logs to be enabled for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(Logs logs);

        /**
         * The list of information about logs to be enabled for the specified broker. This is a convenience that creates
         * an instance of the {@link Logs.Builder} avoiding the need to create one manually via {@link Logs#builder()}.
         *
         * When the {@link Consumer} completes, {@link Logs.Builder#build()} is called immediately and its result is
         * passed to {@link #logs(Logs)}.
         * 
         * @param logs
         *        a consumer that will call methods on {@link Logs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logs(Logs)
         */
        default Builder logs(Consumer<Logs.Builder> logs) {
            return logs(Logs.builder().applyMutation(logs).build());
        }

        /**
         * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * 
         * @param securityGroups
         *        The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * 
         * @param securityGroups
         *        The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private Boolean autoMinorVersionUpgrade;

        private String brokerId;

        private ConfigurationId configuration;

        private String engineVersion;

        private String hostInstanceType;

        private Logs logs;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerResponse model) {
            super(model);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            brokerId(model.brokerId);
            configuration(model.configuration);
            engineVersion(model.engineVersion);
            hostInstanceType(model.hostInstanceType);
            logs(model.logs);
            securityGroups(model.securityGroups);
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getBrokerId() {
            return brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final ConfigurationId.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ConfigurationId configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ConfigurationId.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getHostInstanceType() {
            return hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        public final Logs.Builder getLogs() {
            return logs != null ? logs.toBuilder() : null;
        }

        @Override
        public final Builder logs(Logs logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(Logs.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public UpdateBrokerResponse build() {
            return new UpdateBrokerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
