/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Encryption options for the broker.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionOptions.Builder, EncryptionOptions> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EncryptionOptions::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<Boolean> USE_AWS_OWNED_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EncryptionOptions::useAwsOwnedKey)).setter(setter(Builder::useAwsOwnedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useAwsOwnedKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            USE_AWS_OWNED_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final Boolean useAwsOwnedKey;

    private EncryptionOptions(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.useAwsOwnedKey = builder.useAwsOwnedKey;
    }

    /**
     * The customer master key (CMK) to use for the AWS Key Management Service (KMS). This key is used to encrypt your
     * data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.
     * 
     * @return The customer master key (CMK) to use for the AWS Key Management Service (KMS). This key is used to
     *         encrypt your data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Enables the use of an AWS owned CMK using AWS Key Management Service (KMS).
     * 
     * @return Enables the use of an AWS owned CMK using AWS Key Management Service (KMS).
     */
    public Boolean useAwsOwnedKey() {
        return useAwsOwnedKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(useAwsOwnedKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionOptions)) {
            return false;
        }
        EncryptionOptions other = (EncryptionOptions) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(useAwsOwnedKey(), other.useAwsOwnedKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EncryptionOptions").add("KmsKeyId", kmsKeyId()).add("UseAwsOwnedKey", useAwsOwnedKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "UseAwsOwnedKey":
            return Optional.ofNullable(clazz.cast(useAwsOwnedKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionOptions, T> g) {
        return obj -> g.apply((EncryptionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionOptions> {
        /**
         * The customer master key (CMK) to use for the AWS Key Management Service (KMS). This key is used to encrypt
         * your data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.
         * 
         * @param kmsKeyId
         *        The customer master key (CMK) to use for the AWS Key Management Service (KMS). This key is used to
         *        encrypt your data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * Enables the use of an AWS owned CMK using AWS Key Management Service (KMS).
         * 
         * @param useAwsOwnedKey
         *        Enables the use of an AWS owned CMK using AWS Key Management Service (KMS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useAwsOwnedKey(Boolean useAwsOwnedKey);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private Boolean useAwsOwnedKey;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionOptions model) {
            kmsKeyId(model.kmsKeyId);
            useAwsOwnedKey(model.useAwsOwnedKey);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getUseAwsOwnedKey() {
            return useAwsOwnedKey;
        }

        @Override
        public final Builder useAwsOwnedKey(Boolean useAwsOwnedKey) {
            this.useAwsOwnedKey = useAwsOwnedKey;
            return this;
        }

        public final void setUseAwsOwnedKey(Boolean useAwsOwnedKey) {
            this.useAwsOwnedKey = useAwsOwnedKey;
        }

        @Override
        public EncryptionOptions build() {
            return new EncryptionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
