/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBrokerEngineTypesResponse extends MqResponse implements
        ToCopyableBuilder<DescribeBrokerEngineTypesResponse.Builder, DescribeBrokerEngineTypesResponse> {
    private static final SdkField<List<BrokerEngineType>> BROKER_ENGINE_TYPES_FIELD = SdkField
            .<List<BrokerEngineType>> builder(MarshallingType.LIST)
            .getter(getter(DescribeBrokerEngineTypesResponse::brokerEngineTypes))
            .setter(setter(Builder::brokerEngineTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerEngineTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrokerEngineType> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrokerEngineType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeBrokerEngineTypesResponse::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerEngineTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ENGINE_TYPES_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<BrokerEngineType> brokerEngineTypes;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeBrokerEngineTypesResponse(BuilderImpl builder) {
        super(builder);
        this.brokerEngineTypes = builder.brokerEngineTypes;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BrokerEngineTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBrokerEngineTypes() {
        return brokerEngineTypes != null && !(brokerEngineTypes instanceof SdkAutoConstructList);
    }

    /**
     * List of available engine types and versions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBrokerEngineTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of available engine types and versions.
     */
    public List<BrokerEngineType> brokerEngineTypes() {
        return brokerEngineTypes;
    }

    /**
     * Required. The maximum number of engine types that can be returned per page (20 by default). This value must be an
     * integer from 5 to 100.
     * 
     * @return Required. The maximum number of engine types that can be returned per page (20 by default). This value
     *         must be an integer from 5 to 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
     * nextToken empty.
     * 
     * @return The token that specifies the next page of results Amazon MQ should return. To request the first page,
     *         leave nextToken empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(brokerEngineTypes());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerEngineTypesResponse)) {
            return false;
        }
        DescribeBrokerEngineTypesResponse other = (DescribeBrokerEngineTypesResponse) obj;
        return Objects.equals(brokerEngineTypes(), other.brokerEngineTypes()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeBrokerEngineTypesResponse").add("BrokerEngineTypes", brokerEngineTypes())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerEngineTypes":
            return Optional.ofNullable(clazz.cast(brokerEngineTypes()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrokerEngineTypesResponse, T> g) {
        return obj -> g.apply((DescribeBrokerEngineTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBrokerEngineTypesResponse> {
        /**
         * List of available engine types and versions.
         * 
         * @param brokerEngineTypes
         *        List of available engine types and versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerEngineTypes(Collection<BrokerEngineType> brokerEngineTypes);

        /**
         * List of available engine types and versions.
         * 
         * @param brokerEngineTypes
         *        List of available engine types and versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerEngineTypes(BrokerEngineType... brokerEngineTypes);

        /**
         * List of available engine types and versions. This is a convenience that creates an instance of the
         * {@link List<BrokerEngineType>.Builder} avoiding the need to create one manually via {@link List
         * <BrokerEngineType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BrokerEngineType>.Builder#build()} is called immediately and
         * its result is passed to {@link #brokerEngineTypes(List<BrokerEngineType>)}.
         * 
         * @param brokerEngineTypes
         *        a consumer that will call methods on {@link List<BrokerEngineType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerEngineTypes(List<BrokerEngineType>)
         */
        Builder brokerEngineTypes(Consumer<BrokerEngineType.Builder>... brokerEngineTypes);

        /**
         * Required. The maximum number of engine types that can be returned per page (20 by default). This value must
         * be an integer from 5 to 100.
         * 
         * @param maxResults
         *        Required. The maximum number of engine types that can be returned per page (20 by default). This value
         *        must be an integer from 5 to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
         * nextToken empty.
         * 
         * @param nextToken
         *        The token that specifies the next page of results Amazon MQ should return. To request the first page,
         *        leave nextToken empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private List<BrokerEngineType> brokerEngineTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerEngineTypesResponse model) {
            super(model);
            brokerEngineTypes(model.brokerEngineTypes);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<BrokerEngineType.Builder> getBrokerEngineTypes() {
            return brokerEngineTypes != null ? brokerEngineTypes.stream().map(BrokerEngineType::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder brokerEngineTypes(Collection<BrokerEngineType> brokerEngineTypes) {
            this.brokerEngineTypes = ___listOfBrokerEngineTypeCopier.copy(brokerEngineTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEngineTypes(BrokerEngineType... brokerEngineTypes) {
            brokerEngineTypes(Arrays.asList(brokerEngineTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEngineTypes(Consumer<BrokerEngineType.Builder>... brokerEngineTypes) {
            brokerEngineTypes(Stream.of(brokerEngineTypes).map(c -> BrokerEngineType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBrokerEngineTypes(Collection<BrokerEngineType.BuilderImpl> brokerEngineTypes) {
            this.brokerEngineTypes = ___listOfBrokerEngineTypeCopier.copyFromBuilder(brokerEngineTypes);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBrokerEngineTypesResponse build() {
            return new DescribeBrokerEngineTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
