/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Returns information about all configurations.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Configuration implements SdkPojo, Serializable, ToCopyableBuilder<Configuration.Builder, Configuration> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Configuration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Configuration::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Configuration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Configuration::engineTypeAsString)).setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Configuration::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Configuration::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ConfigurationRevision> LATEST_REVISION_FIELD = SdkField
            .<ConfigurationRevision> builder(MarshallingType.SDK_POJO).getter(getter(Configuration::latestRevision))
            .setter(setter(Builder::latestRevision)).constructor(ConfigurationRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Configuration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Configuration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_FIELD,
            DESCRIPTION_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, ID_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant created;

    private final String description;

    private final String engineType;

    private final String engineVersion;

    private final String id;

    private final ConfigurationRevision latestRevision;

    private final String name;

    private final Map<String, String> tags;

    private Configuration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.created = builder.created;
        this.description = builder.description;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.id = builder.id;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * Required. The ARN of the configuration.
     * 
     * @return Required. The ARN of the configuration.
     */
    public String arn() {
        return arn;
    }

    /**
     * Required. The date and time of the configuration revision.
     * 
     * @return Required. The date and time of the configuration revision.
     */
    public Instant created() {
        return created;
    }

    /**
     * Required. The description of the configuration.
     * 
     * @return Required. The description of the configuration.
     */
    public String description() {
        return description;
    }

    /**
     * Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
     * @see EngineType
     */
    public EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
     * @see EngineType
     */
    public String engineTypeAsString() {
        return engineType;
    }

    /**
     * Required. The version of the broker engine. For a list of supported engine versions, see
     * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
     * 
     * @return Required. The version of the broker engine. For a list of supported engine versions, see
     *         https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * Required. The unique ID that Amazon MQ generates for the configuration.
     * 
     * @return Required. The unique ID that Amazon MQ generates for the configuration.
     */
    public String id() {
        return id;
    }

    /**
     * Required. The latest revision of the configuration.
     * 
     * @return Required. The latest revision of the configuration.
     */
    public ConfigurationRevision latestRevision() {
        return latestRevision;
    }

    /**
     * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods,
     * underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
     * 
     * @return Required. The name of the configuration. This value can contain only alphanumeric characters, dashes,
     *         periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * The list of all tags associated with this configuration.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of all tags associated with this configuration.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(created(), other.created())
                && Objects.equals(description(), other.description())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(id(), other.id())
                && Objects.equals(latestRevision(), other.latestRevision()) && Objects.equals(name(), other.name())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Configuration").add("Arn", arn()).add("Created", created()).add("Description", description())
                .add("EngineType", engineTypeAsString()).add("EngineVersion", engineVersion()).add("Id", id())
                .add("LatestRevision", latestRevision()).add("Name", name()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EngineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LatestRevision":
            return Optional.ofNullable(clazz.cast(latestRevision()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configuration, T> g) {
        return obj -> g.apply((Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Configuration> {
        /**
         * Required. The ARN of the configuration.
         * 
         * @param arn
         *        Required. The ARN of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Required. The date and time of the configuration revision.
         * 
         * @param created
         *        Required. The date and time of the configuration revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * Required. The description of the configuration.
         * 
         * @param description
         *        Required. The description of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
         * 
         * @param engineType
         *        Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
         * 
         * @param engineType
         *        Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * Required. The version of the broker engine. For a list of supported engine versions, see
         * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
         * 
         * @param engineVersion
         *        Required. The version of the broker engine. For a list of supported engine versions, see
         *        https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * Required. The unique ID that Amazon MQ generates for the configuration.
         * 
         * @param id
         *        Required. The unique ID that Amazon MQ generates for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Required. The latest revision of the configuration.
         * 
         * @param latestRevision
         *        Required. The latest revision of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevision(ConfigurationRevision latestRevision);

        /**
         * Required. The latest revision of the configuration. This is a convenience that creates an instance of the
         * {@link ConfigurationRevision.Builder} avoiding the need to create one manually via
         * {@link ConfigurationRevision#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationRevision.Builder#build()} is called immediately and
         * its result is passed to {@link #latestRevision(ConfigurationRevision)}.
         * 
         * @param latestRevision
         *        a consumer that will call methods on {@link ConfigurationRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevision(ConfigurationRevision)
         */
        default Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return latestRevision(ConfigurationRevision.builder().applyMutation(latestRevision).build());
        }

        /**
         * Required. The name of the configuration. This value can contain only alphanumeric characters, dashes,
         * periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
         * 
         * @param name
         *        Required. The name of the configuration. This value can contain only alphanumeric characters, dashes,
         *        periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The list of all tags associated with this configuration.
         * 
         * @param tags
         *        The list of all tags associated with this configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant created;

        private String description;

        private String engineType;

        private String engineVersion;

        private String id;

        private ConfigurationRevision latestRevision;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            arn(model.arn);
            created(model.created);
            description(model.description);
            engineType(model.engineType);
            engineVersion(model.engineVersion);
            id(model.id);
            latestRevision(model.latestRevision);
            name(model.name);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEngineType() {
            return engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return latestRevision != null ? latestRevision.toBuilder() : null;
        }

        @Override
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public Configuration build() {
            return new Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
