/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBrokersResponse extends MqResponse implements
        ToCopyableBuilder<ListBrokersResponse.Builder, ListBrokersResponse> {
    private static final SdkField<List<BrokerSummary>> BROKER_SUMMARIES_FIELD = SdkField
            .<List<BrokerSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListBrokersResponse::brokerSummaries))
            .setter(setter(Builder::brokerSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrokerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrokerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBrokersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BrokerSummary> brokerSummaries;

    private final String nextToken;

    private ListBrokersResponse(BuilderImpl builder) {
        super(builder);
        this.brokerSummaries = builder.brokerSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BrokerSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBrokerSummaries() {
        return brokerSummaries != null && !(brokerSummaries instanceof SdkAutoConstructList);
    }

    /**
     * A list of information about all brokers.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBrokerSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of information about all brokers.
     */
    public List<BrokerSummary> brokerSummaries() {
        return brokerSummaries;
    }

    /**
     * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
     * nextToken empty.
     * 
     * @return The token that specifies the next page of results Amazon MQ should return. To request the first page,
     *         leave nextToken empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(brokerSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBrokersResponse)) {
            return false;
        }
        ListBrokersResponse other = (ListBrokersResponse) obj;
        return Objects.equals(brokerSummaries(), other.brokerSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListBrokersResponse").add("BrokerSummaries", brokerSummaries()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerSummaries":
            return Optional.ofNullable(clazz.cast(brokerSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBrokersResponse, T> g) {
        return obj -> g.apply((ListBrokersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBrokersResponse> {
        /**
         * A list of information about all brokers.
         * 
         * @param brokerSummaries
         *        A list of information about all brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerSummaries(Collection<BrokerSummary> brokerSummaries);

        /**
         * A list of information about all brokers.
         * 
         * @param brokerSummaries
         *        A list of information about all brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerSummaries(BrokerSummary... brokerSummaries);

        /**
         * A list of information about all brokers. This is a convenience that creates an instance of the {@link List
         * <BrokerSummary>.Builder} avoiding the need to create one manually via {@link List<BrokerSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BrokerSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #brokerSummaries(List<BrokerSummary>)}.
         * 
         * @param brokerSummaries
         *        a consumer that will call methods on {@link List<BrokerSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerSummaries(List<BrokerSummary>)
         */
        Builder brokerSummaries(Consumer<BrokerSummary.Builder>... brokerSummaries);

        /**
         * The token that specifies the next page of results Amazon MQ should return. To request the first page, leave
         * nextToken empty.
         * 
         * @param nextToken
         *        The token that specifies the next page of results Amazon MQ should return. To request the first page,
         *        leave nextToken empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private List<BrokerSummary> brokerSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBrokersResponse model) {
            super(model);
            brokerSummaries(model.brokerSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<BrokerSummary.Builder> getBrokerSummaries() {
            return brokerSummaries != null ? brokerSummaries.stream().map(BrokerSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder brokerSummaries(Collection<BrokerSummary> brokerSummaries) {
            this.brokerSummaries = ___listOfBrokerSummaryCopier.copy(brokerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerSummaries(BrokerSummary... brokerSummaries) {
            brokerSummaries(Arrays.asList(brokerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerSummaries(Consumer<BrokerSummary.Builder>... brokerSummaries) {
            brokerSummaries(Stream.of(brokerSummaries).map(c -> BrokerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBrokerSummaries(Collection<BrokerSummary.BuilderImpl> brokerSummaries) {
            this.brokerSummaries = ___listOfBrokerSummaryCopier.copyFromBuilder(brokerSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBrokersResponse build() {
            return new ListBrokersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
