/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBrokerResponse extends MqResponse implements
        ToCopyableBuilder<DescribeBrokerResponse.Builder, DescribeBrokerResponse> {
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeBrokerResponse::autoMinorVersionUpgrade)).setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> BROKER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::brokerArn)).setter(setter(Builder::brokerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerArn").build()).build();

    private static final SdkField<String> BROKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::brokerId)).setter(setter(Builder::brokerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()).build();

    private static final SdkField<List<BrokerInstance>> BROKER_INSTANCES_FIELD = SdkField
            .<List<BrokerInstance>> builder(MarshallingType.LIST)
            .getter(getter(DescribeBrokerResponse::brokerInstances))
            .setter(setter(Builder::brokerInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrokerInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrokerInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BROKER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::brokerName)).setter(setter(Builder::brokerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerName").build()).build();

    private static final SdkField<String> BROKER_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::brokerStateAsString)).setter(setter(Builder::brokerState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerState").build()).build();

    private static final SdkField<Configurations> CONFIGURATIONS_FIELD = SdkField
            .<Configurations> builder(MarshallingType.SDK_POJO).getter(getter(DescribeBrokerResponse::configurations))
            .setter(setter(Builder::configurations)).constructor(Configurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeBrokerResponse::created))
            .setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::deploymentModeAsString)).setter(setter(Builder::deploymentMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentMode").build()).build();

    private static final SdkField<EncryptionOptions> ENCRYPTION_OPTIONS_FIELD = SdkField
            .<EncryptionOptions> builder(MarshallingType.SDK_POJO).getter(getter(DescribeBrokerResponse::encryptionOptions))
            .setter(setter(Builder::encryptionOptions)).constructor(EncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionOptions").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::engineTypeAsString)).setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::hostInstanceType)).setter(setter(Builder::hostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()).build();

    private static final SdkField<LogsSummary> LOGS_FIELD = SdkField.<LogsSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeBrokerResponse::logs)).setter(setter(Builder::logs)).constructor(LogsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()).build();

    private static final SdkField<WeeklyStartTime> MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField
            .<WeeklyStartTime> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeBrokerResponse::maintenanceWindowStartTime))
            .setter(setter(Builder::maintenanceWindowStartTime))
            .constructor(WeeklyStartTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindowStartTime").build())
            .build();

    private static final SdkField<String> PENDING_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::pendingEngineVersion)).setter(setter(Builder::pendingEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingEngineVersion").build())
            .build();

    private static final SdkField<String> PENDING_HOST_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::pendingHostInstanceType)).setter(setter(Builder::pendingHostInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingHostInstanceType").build())
            .build();

    private static final SdkField<List<String>> PENDING_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeBrokerResponse::pendingSecurityGroups))
            .setter(setter(Builder::pendingSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeBrokerResponse::publiclyAccessible)).setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeBrokerResponse::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBrokerResponse::storageTypeAsString)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeBrokerResponse::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeBrokerResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<UserSummary>> USERS_FIELD = SdkField
            .<List<UserSummary>> builder(MarshallingType.LIST)
            .getter(getter(DescribeBrokerResponse::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_ARN_FIELD, BROKER_ID_FIELD, BROKER_INSTANCES_FIELD, BROKER_NAME_FIELD,
            BROKER_STATE_FIELD, CONFIGURATIONS_FIELD, CREATED_FIELD, DEPLOYMENT_MODE_FIELD, ENCRYPTION_OPTIONS_FIELD,
            ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, HOST_INSTANCE_TYPE_FIELD, LOGS_FIELD, MAINTENANCE_WINDOW_START_TIME_FIELD,
            PENDING_ENGINE_VERSION_FIELD, PENDING_HOST_INSTANCE_TYPE_FIELD, PENDING_SECURITY_GROUPS_FIELD,
            PUBLICLY_ACCESSIBLE_FIELD, SECURITY_GROUPS_FIELD, STORAGE_TYPE_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, USERS_FIELD));

    private final Boolean autoMinorVersionUpgrade;

    private final String brokerArn;

    private final String brokerId;

    private final List<BrokerInstance> brokerInstances;

    private final String brokerName;

    private final String brokerState;

    private final Configurations configurations;

    private final Instant created;

    private final String deploymentMode;

    private final EncryptionOptions encryptionOptions;

    private final String engineType;

    private final String engineVersion;

    private final String hostInstanceType;

    private final LogsSummary logs;

    private final WeeklyStartTime maintenanceWindowStartTime;

    private final String pendingEngineVersion;

    private final String pendingHostInstanceType;

    private final List<String> pendingSecurityGroups;

    private final Boolean publiclyAccessible;

    private final List<String> securityGroups;

    private final String storageType;

    private final List<String> subnetIds;

    private final Map<String, String> tags;

    private final List<UserSummary> users;

    private DescribeBrokerResponse(BuilderImpl builder) {
        super(builder);
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerArn = builder.brokerArn;
        this.brokerId = builder.brokerId;
        this.brokerInstances = builder.brokerInstances;
        this.brokerName = builder.brokerName;
        this.brokerState = builder.brokerState;
        this.configurations = builder.configurations;
        this.created = builder.created;
        this.deploymentMode = builder.deploymentMode;
        this.encryptionOptions = builder.encryptionOptions;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.logs = builder.logs;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.pendingEngineVersion = builder.pendingEngineVersion;
        this.pendingHostInstanceType = builder.pendingHostInstanceType;
        this.pendingSecurityGroups = builder.pendingSecurityGroups;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroups = builder.securityGroups;
        this.storageType = builder.storageType;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.users = builder.users;
    }

    /**
     * Required. Enables automatic upgrades to new minor versions for brokers, as Apache releases the versions. The
     * automatic upgrades occur during the maintenance window of the broker or after a manual broker reboot.
     * 
     * @return Required. Enables automatic upgrades to new minor versions for brokers, as Apache releases the versions.
     *         The automatic upgrades occur during the maintenance window of the broker or after a manual broker reboot.
     */
    public Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * The Amazon Resource Name (ARN) of the broker.
     * 
     * @return The Amazon Resource Name (ARN) of the broker.
     */
    public String brokerArn() {
        return brokerArn;
    }

    /**
     * The unique ID that Amazon MQ generates for the broker.
     * 
     * @return The unique ID that Amazon MQ generates for the broker.
     */
    public String brokerId() {
        return brokerId;
    }

    /**
     * Returns true if the BrokerInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBrokerInstances() {
        return brokerInstances != null && !(brokerInstances instanceof SdkAutoConstructList);
    }

    /**
     * A list of information about allocated brokers.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBrokerInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of information about allocated brokers.
     */
    public List<BrokerInstance> brokerInstances() {
        return brokerInstances;
    }

    /**
     * The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain only
     * letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard characters, or
     * special characters.
     * 
     * @return The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain
     *         only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard
     *         characters, or special characters.
     */
    public String brokerName() {
        return brokerName;
    }

    /**
     * The status of the broker.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brokerState} will
     * return {@link BrokerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brokerStateAsString}.
     * </p>
     * 
     * @return The status of the broker.
     * @see BrokerState
     */
    public BrokerState brokerState() {
        return BrokerState.fromValue(brokerState);
    }

    /**
     * The status of the broker.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brokerState} will
     * return {@link BrokerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brokerStateAsString}.
     * </p>
     * 
     * @return The status of the broker.
     * @see BrokerState
     */
    public String brokerStateAsString() {
        return brokerState;
    }

    /**
     * The list of all revisions for the specified configuration.
     * 
     * @return The list of all revisions for the specified configuration.
     */
    public Configurations configurations() {
        return configurations;
    }

    /**
     * The time when the broker was created.
     * 
     * @return The time when the broker was created.
     */
    public Instant created() {
        return created;
    }

    /**
     * Required. The deployment mode of the broker.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return Required. The deployment mode of the broker.
     * @see DeploymentMode
     */
    public DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(deploymentMode);
    }

    /**
     * Required. The deployment mode of the broker.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deploymentMode}
     * will return {@link DeploymentMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deploymentModeAsString}.
     * </p>
     * 
     * @return Required. The deployment mode of the broker.
     * @see DeploymentMode
     */
    public String deploymentModeAsString() {
        return deploymentMode;
    }

    /**
     * Encryption options for the broker.
     * 
     * @return Encryption options for the broker.
     */
    public EncryptionOptions encryptionOptions() {
        return encryptionOptions;
    }

    /**
     * Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
     * @see EngineType
     */
    public EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
     * @see EngineType
     */
    public String engineTypeAsString() {
        return engineType;
    }

    /**
     * The version of the broker engine. For a list of supported engine versions, see
     * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
     * 
     * @return The version of the broker engine. For a list of supported engine versions, see
     *         https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * The broker's instance type.
     * 
     * @return The broker's instance type.
     */
    public String hostInstanceType() {
        return hostInstanceType;
    }

    /**
     * The list of information about logs currently enabled and pending to be deployed for the specified broker.
     * 
     * @return The list of information about logs currently enabled and pending to be deployed for the specified broker.
     */
    public LogsSummary logs() {
        return logs;
    }

    /**
     * The parameters that determine the WeeklyStartTime.
     * 
     * @return The parameters that determine the WeeklyStartTime.
     */
    public WeeklyStartTime maintenanceWindowStartTime() {
        return maintenanceWindowStartTime;
    }

    /**
     * The version of the broker engine to upgrade to. For a list of supported engine versions, see
     * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
     * 
     * @return The version of the broker engine to upgrade to. For a list of supported engine versions, see
     *         https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
     */
    public String pendingEngineVersion() {
        return pendingEngineVersion;
    }

    /**
     * The host instance type of the broker to upgrade to. For a list of supported instance types, see
     * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide//broker.html#broker-instance-types
     * 
     * @return The host instance type of the broker to upgrade to. For a list of supported instance types, see
     *         https://docs.aws.amazon.com/amazon-mq/latest/developer-guide//broker.html#broker-instance-types
     */
    public String pendingHostInstanceType() {
        return pendingHostInstanceType;
    }

    /**
     * Returns true if the PendingSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPendingSecurityGroups() {
        return pendingSecurityGroups != null && !(pendingSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * The list of pending security groups to authorize connections to brokers.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPendingSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of pending security groups to authorize connections to brokers.
     */
    public List<String> pendingSecurityGroups() {
        return pendingSecurityGroups;
    }

    /**
     * Required. Enables connections from applications outside of the VPC that hosts the broker's subnets.
     * 
     * @return Required. Enables connections from applications outside of the VPC that hosts the broker's subnets.
     */
    public Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * The broker's storage type.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link BrokerStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The broker's storage type.
     * @see BrokerStorageType
     */
    public BrokerStorageType storageType() {
        return BrokerStorageType.fromValue(storageType);
    }

    /**
     * The broker's storage type.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link BrokerStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The broker's storage type.
     * @see BrokerStorageType
     */
    public String storageTypeAsString() {
        return storageType;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * The list of groups (2 maximum) that define which subnets and IP ranges the broker can use from different
     * Availability Zones. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An
     * ACTIVE_STANDBY_MULTI_AZ deployment requires two subnets.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of groups (2 maximum) that define which subnets and IP ranges the broker can use from different
     *         Availability Zones. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet).
     *         An ACTIVE_STANDBY_MULTI_AZ deployment requires two subnets.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * The list of all tags associated with this broker.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of all tags associated with this broker.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns true if the Users property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * The list of all ActiveMQ usernames for the specified broker.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUsers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of all ActiveMQ usernames for the specified broker.
     */
    public List<UserSummary> users() {
        return users;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(brokerArn());
        hashCode = 31 * hashCode + Objects.hashCode(brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(brokerInstances());
        hashCode = 31 * hashCode + Objects.hashCode(brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(brokerStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configurations());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(logs());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(pendingEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(pendingHostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(pendingSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(users());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerResponse)) {
            return false;
        }
        DescribeBrokerResponse other = (DescribeBrokerResponse) obj;
        return Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(brokerArn(), other.brokerArn()) && Objects.equals(brokerId(), other.brokerId())
                && Objects.equals(brokerInstances(), other.brokerInstances()) && Objects.equals(brokerName(), other.brokerName())
                && Objects.equals(brokerStateAsString(), other.brokerStateAsString())
                && Objects.equals(configurations(), other.configurations()) && Objects.equals(created(), other.created())
                && Objects.equals(deploymentModeAsString(), other.deploymentModeAsString())
                && Objects.equals(encryptionOptions(), other.encryptionOptions())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(hostInstanceType(), other.hostInstanceType()) && Objects.equals(logs(), other.logs())
                && Objects.equals(maintenanceWindowStartTime(), other.maintenanceWindowStartTime())
                && Objects.equals(pendingEngineVersion(), other.pendingEngineVersion())
                && Objects.equals(pendingHostInstanceType(), other.pendingHostInstanceType())
                && Objects.equals(pendingSecurityGroups(), other.pendingSecurityGroups())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(tags(), other.tags())
                && Objects.equals(users(), other.users());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeBrokerResponse").add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("BrokerArn", brokerArn()).add("BrokerId", brokerId()).add("BrokerInstances", brokerInstances())
                .add("BrokerName", brokerName()).add("BrokerState", brokerStateAsString())
                .add("Configurations", configurations()).add("Created", created())
                .add("DeploymentMode", deploymentModeAsString()).add("EncryptionOptions", encryptionOptions())
                .add("EngineType", engineTypeAsString()).add("EngineVersion", engineVersion())
                .add("HostInstanceType", hostInstanceType()).add("Logs", logs())
                .add("MaintenanceWindowStartTime", maintenanceWindowStartTime())
                .add("PendingEngineVersion", pendingEngineVersion()).add("PendingHostInstanceType", pendingHostInstanceType())
                .add("PendingSecurityGroups", pendingSecurityGroups()).add("PubliclyAccessible", publiclyAccessible())
                .add("SecurityGroups", securityGroups()).add("StorageType", storageTypeAsString()).add("SubnetIds", subnetIds())
                .add("Tags", tags()).add("Users", users()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "BrokerArn":
            return Optional.ofNullable(clazz.cast(brokerArn()));
        case "BrokerId":
            return Optional.ofNullable(clazz.cast(brokerId()));
        case "BrokerInstances":
            return Optional.ofNullable(clazz.cast(brokerInstances()));
        case "BrokerName":
            return Optional.ofNullable(clazz.cast(brokerName()));
        case "BrokerState":
            return Optional.ofNullable(clazz.cast(brokerStateAsString()));
        case "Configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "DeploymentMode":
            return Optional.ofNullable(clazz.cast(deploymentModeAsString()));
        case "EncryptionOptions":
            return Optional.ofNullable(clazz.cast(encryptionOptions()));
        case "EngineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "HostInstanceType":
            return Optional.ofNullable(clazz.cast(hostInstanceType()));
        case "Logs":
            return Optional.ofNullable(clazz.cast(logs()));
        case "MaintenanceWindowStartTime":
            return Optional.ofNullable(clazz.cast(maintenanceWindowStartTime()));
        case "PendingEngineVersion":
            return Optional.ofNullable(clazz.cast(pendingEngineVersion()));
        case "PendingHostInstanceType":
            return Optional.ofNullable(clazz.cast(pendingHostInstanceType()));
        case "PendingSecurityGroups":
            return Optional.ofNullable(clazz.cast(pendingSecurityGroups()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrokerResponse, T> g) {
        return obj -> g.apply((DescribeBrokerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBrokerResponse> {
        /**
         * Required. Enables automatic upgrades to new minor versions for brokers, as Apache releases the versions. The
         * automatic upgrades occur during the maintenance window of the broker or after a manual broker reboot.
         * 
         * @param autoMinorVersionUpgrade
         *        Required. Enables automatic upgrades to new minor versions for brokers, as Apache releases the
         *        versions. The automatic upgrades occur during the maintenance window of the broker or after a manual
         *        broker reboot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * The Amazon Resource Name (ARN) of the broker.
         * 
         * @param brokerArn
         *        The Amazon Resource Name (ARN) of the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerArn(String brokerArn);

        /**
         * The unique ID that Amazon MQ generates for the broker.
         * 
         * @param brokerId
         *        The unique ID that Amazon MQ generates for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerId(String brokerId);

        /**
         * A list of information about allocated brokers.
         * 
         * @param brokerInstances
         *        A list of information about allocated brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerInstances(Collection<BrokerInstance> brokerInstances);

        /**
         * A list of information about allocated brokers.
         * 
         * @param brokerInstances
         *        A list of information about allocated brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerInstances(BrokerInstance... brokerInstances);

        /**
         * A list of information about allocated brokers. This is a convenience that creates an instance of the
         * {@link List<BrokerInstance>.Builder} avoiding the need to create one manually via {@link List
         * <BrokerInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BrokerInstance>.Builder#build()} is called immediately and
         * its result is passed to {@link #brokerInstances(List<BrokerInstance>)}.
         * 
         * @param brokerInstances
         *        a consumer that will call methods on {@link List<BrokerInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerInstances(List<BrokerInstance>)
         */
        Builder brokerInstances(Consumer<BrokerInstance.Builder>... brokerInstances);

        /**
         * The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain
         * only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard
         * characters, or special characters.
         * 
         * @param brokerName
         *        The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must
         *        contain only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets,
         *        wildcard characters, or special characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerName(String brokerName);

        /**
         * The status of the broker.
         * 
         * @param brokerState
         *        The status of the broker.
         * @see BrokerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerState
         */
        Builder brokerState(String brokerState);

        /**
         * The status of the broker.
         * 
         * @param brokerState
         *        The status of the broker.
         * @see BrokerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerState
         */
        Builder brokerState(BrokerState brokerState);

        /**
         * The list of all revisions for the specified configuration.
         * 
         * @param configurations
         *        The list of all revisions for the specified configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Configurations configurations);

        /**
         * The list of all revisions for the specified configuration. This is a convenience that creates an instance of
         * the {@link Configurations.Builder} avoiding the need to create one manually via
         * {@link Configurations#builder()}.
         *
         * When the {@link Consumer} completes, {@link Configurations.Builder#build()} is called immediately and its
         * result is passed to {@link #configurations(Configurations)}.
         * 
         * @param configurations
         *        a consumer that will call methods on {@link Configurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurations(Configurations)
         */
        default Builder configurations(Consumer<Configurations.Builder> configurations) {
            return configurations(Configurations.builder().applyMutation(configurations).build());
        }

        /**
         * The time when the broker was created.
         * 
         * @param created
         *        The time when the broker was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * Required. The deployment mode of the broker.
         * 
         * @param deploymentMode
         *        Required. The deployment mode of the broker.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(String deploymentMode);

        /**
         * Required. The deployment mode of the broker.
         * 
         * @param deploymentMode
         *        Required. The deployment mode of the broker.
         * @see DeploymentMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentMode
         */
        Builder deploymentMode(DeploymentMode deploymentMode);

        /**
         * Encryption options for the broker.
         * 
         * @param encryptionOptions
         *        Encryption options for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionOptions(EncryptionOptions encryptionOptions);

        /**
         * Encryption options for the broker. This is a convenience that creates an instance of the
         * {@link EncryptionOptions.Builder} avoiding the need to create one manually via
         * {@link EncryptionOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionOptions(EncryptionOptions)}.
         * 
         * @param encryptionOptions
         *        a consumer that will call methods on {@link EncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionOptions(EncryptionOptions)
         */
        default Builder encryptionOptions(Consumer<EncryptionOptions.Builder> encryptionOptions) {
            return encryptionOptions(EncryptionOptions.builder().applyMutation(encryptionOptions).build());
        }

        /**
         * Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
         * 
         * @param engineType
         *        Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
         * 
         * @param engineType
         *        Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);

        /**
         * The version of the broker engine. For a list of supported engine versions, see
         * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
         * 
         * @param engineVersion
         *        The version of the broker engine. For a list of supported engine versions, see
         *        https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * The broker's instance type.
         * 
         * @param hostInstanceType
         *        The broker's instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostInstanceType(String hostInstanceType);

        /**
         * The list of information about logs currently enabled and pending to be deployed for the specified broker.
         * 
         * @param logs
         *        The list of information about logs currently enabled and pending to be deployed for the specified
         *        broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(LogsSummary logs);

        /**
         * The list of information about logs currently enabled and pending to be deployed for the specified broker.
         * This is a convenience that creates an instance of the {@link LogsSummary.Builder} avoiding the need to create
         * one manually via {@link LogsSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogsSummary.Builder#build()} is called immediately and its result
         * is passed to {@link #logs(LogsSummary)}.
         * 
         * @param logs
         *        a consumer that will call methods on {@link LogsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logs(LogsSummary)
         */
        default Builder logs(Consumer<LogsSummary.Builder> logs) {
            return logs(LogsSummary.builder().applyMutation(logs).build());
        }

        /**
         * The parameters that determine the WeeklyStartTime.
         * 
         * @param maintenanceWindowStartTime
         *        The parameters that determine the WeeklyStartTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime);

        /**
         * The parameters that determine the WeeklyStartTime. This is a convenience that creates an instance of the
         * {@link WeeklyStartTime.Builder} avoiding the need to create one manually via
         * {@link WeeklyStartTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link WeeklyStartTime.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindowStartTime(WeeklyStartTime)}.
         * 
         * @param maintenanceWindowStartTime
         *        a consumer that will call methods on {@link WeeklyStartTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindowStartTime(WeeklyStartTime)
         */
        default Builder maintenanceWindowStartTime(Consumer<WeeklyStartTime.Builder> maintenanceWindowStartTime) {
            return maintenanceWindowStartTime(WeeklyStartTime.builder().applyMutation(maintenanceWindowStartTime).build());
        }

        /**
         * The version of the broker engine to upgrade to. For a list of supported engine versions, see
         * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
         * 
         * @param pendingEngineVersion
         *        The version of the broker engine to upgrade to. For a list of supported engine versions, see
         *        https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingEngineVersion(String pendingEngineVersion);

        /**
         * The host instance type of the broker to upgrade to. For a list of supported instance types, see
         * https://docs.aws.amazon.com/amazon-mq/latest/developer-guide//broker.html#broker-instance-types
         * 
         * @param pendingHostInstanceType
         *        The host instance type of the broker to upgrade to. For a list of supported instance types, see
         *        https://docs.aws.amazon.com/amazon-mq/latest/developer-guide//broker.html#broker-instance-types
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingHostInstanceType(String pendingHostInstanceType);

        /**
         * The list of pending security groups to authorize connections to brokers.
         * 
         * @param pendingSecurityGroups
         *        The list of pending security groups to authorize connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingSecurityGroups(Collection<String> pendingSecurityGroups);

        /**
         * The list of pending security groups to authorize connections to brokers.
         * 
         * @param pendingSecurityGroups
         *        The list of pending security groups to authorize connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingSecurityGroups(String... pendingSecurityGroups);

        /**
         * Required. Enables connections from applications outside of the VPC that hosts the broker's subnets.
         * 
         * @param publiclyAccessible
         *        Required. Enables connections from applications outside of the VPC that hosts the broker's subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * 
         * @param securityGroups
         *        The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * 
         * @param securityGroups
         *        The list of security groups (1 minimum, 5 maximum) that authorizes connections to brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * The broker's storage type.
         * 
         * @param storageType
         *        The broker's storage type.
         * @see BrokerStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerStorageType
         */
        Builder storageType(String storageType);

        /**
         * The broker's storage type.
         * 
         * @param storageType
         *        The broker's storage type.
         * @see BrokerStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrokerStorageType
         */
        Builder storageType(BrokerStorageType storageType);

        /**
         * The list of groups (2 maximum) that define which subnets and IP ranges the broker can use from different
         * Availability Zones. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An
         * ACTIVE_STANDBY_MULTI_AZ deployment requires two subnets.
         * 
         * @param subnetIds
         *        The list of groups (2 maximum) that define which subnets and IP ranges the broker can use from
         *        different Availability Zones. A SINGLE_INSTANCE deployment requires one subnet (for example, the
         *        default subnet). An ACTIVE_STANDBY_MULTI_AZ deployment requires two subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * The list of groups (2 maximum) that define which subnets and IP ranges the broker can use from different
         * Availability Zones. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An
         * ACTIVE_STANDBY_MULTI_AZ deployment requires two subnets.
         * 
         * @param subnetIds
         *        The list of groups (2 maximum) that define which subnets and IP ranges the broker can use from
         *        different Availability Zones. A SINGLE_INSTANCE deployment requires one subnet (for example, the
         *        default subnet). An ACTIVE_STANDBY_MULTI_AZ deployment requires two subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * The list of all tags associated with this broker.
         * 
         * @param tags
         *        The list of all tags associated with this broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * The list of all ActiveMQ usernames for the specified broker.
         * 
         * @param users
         *        The list of all ActiveMQ usernames for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<UserSummary> users);

        /**
         * The list of all ActiveMQ usernames for the specified broker.
         * 
         * @param users
         *        The list of all ActiveMQ usernames for the specified broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(UserSummary... users);

        /**
         * The list of all ActiveMQ usernames for the specified broker. This is a convenience that creates an instance
         * of the {@link List<UserSummary>.Builder} avoiding the need to create one manually via {@link List
         * <UserSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #users(List<UserSummary>)}.
         * 
         * @param users
         *        a consumer that will call methods on {@link List<UserSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(List<UserSummary>)
         */
        Builder users(Consumer<UserSummary.Builder>... users);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private Boolean autoMinorVersionUpgrade;

        private String brokerArn;

        private String brokerId;

        private List<BrokerInstance> brokerInstances = DefaultSdkAutoConstructList.getInstance();

        private String brokerName;

        private String brokerState;

        private Configurations configurations;

        private Instant created;

        private String deploymentMode;

        private EncryptionOptions encryptionOptions;

        private String engineType;

        private String engineVersion;

        private String hostInstanceType;

        private LogsSummary logs;

        private WeeklyStartTime maintenanceWindowStartTime;

        private String pendingEngineVersion;

        private String pendingHostInstanceType;

        private List<String> pendingSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private Boolean publiclyAccessible;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String storageType;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<UserSummary> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerResponse model) {
            super(model);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            brokerArn(model.brokerArn);
            brokerId(model.brokerId);
            brokerInstances(model.brokerInstances);
            brokerName(model.brokerName);
            brokerState(model.brokerState);
            configurations(model.configurations);
            created(model.created);
            deploymentMode(model.deploymentMode);
            encryptionOptions(model.encryptionOptions);
            engineType(model.engineType);
            engineVersion(model.engineVersion);
            hostInstanceType(model.hostInstanceType);
            logs(model.logs);
            maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            pendingEngineVersion(model.pendingEngineVersion);
            pendingHostInstanceType(model.pendingHostInstanceType);
            pendingSecurityGroups(model.pendingSecurityGroups);
            publiclyAccessible(model.publiclyAccessible);
            securityGroups(model.securityGroups);
            storageType(model.storageType);
            subnetIds(model.subnetIds);
            tags(model.tags);
            users(model.users);
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getBrokerArn() {
            return brokerArn;
        }

        @Override
        public final Builder brokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
            return this;
        }

        public final void setBrokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
        }

        public final String getBrokerId() {
            return brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final Collection<BrokerInstance.Builder> getBrokerInstances() {
            return brokerInstances != null ? brokerInstances.stream().map(BrokerInstance::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder brokerInstances(Collection<BrokerInstance> brokerInstances) {
            this.brokerInstances = ___listOfBrokerInstanceCopier.copy(brokerInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstances(BrokerInstance... brokerInstances) {
            brokerInstances(Arrays.asList(brokerInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerInstances(Consumer<BrokerInstance.Builder>... brokerInstances) {
            brokerInstances(Stream.of(brokerInstances).map(c -> BrokerInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBrokerInstances(Collection<BrokerInstance.BuilderImpl> brokerInstances) {
            this.brokerInstances = ___listOfBrokerInstanceCopier.copyFromBuilder(brokerInstances);
        }

        public final String getBrokerName() {
            return brokerName;
        }

        @Override
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        public final String getBrokerStateAsString() {
            return brokerState;
        }

        @Override
        public final Builder brokerState(String brokerState) {
            this.brokerState = brokerState;
            return this;
        }

        @Override
        public final Builder brokerState(BrokerState brokerState) {
            this.brokerState(brokerState == null ? null : brokerState.toString());
            return this;
        }

        public final void setBrokerState(String brokerState) {
            this.brokerState = brokerState;
        }

        public final Configurations.Builder getConfigurations() {
            return configurations != null ? configurations.toBuilder() : null;
        }

        @Override
        public final Builder configurations(Configurations configurations) {
            this.configurations = configurations;
            return this;
        }

        public final void setConfigurations(Configurations.BuilderImpl configurations) {
            this.configurations = configurations != null ? configurations.build() : null;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getDeploymentModeAsString() {
            return deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode == null ? null : deploymentMode.toString());
            return this;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        public final EncryptionOptions.Builder getEncryptionOptions() {
            return encryptionOptions != null ? encryptionOptions.toBuilder() : null;
        }

        @Override
        public final Builder encryptionOptions(EncryptionOptions encryptionOptions) {
            this.encryptionOptions = encryptionOptions;
            return this;
        }

        public final void setEncryptionOptions(EncryptionOptions.BuilderImpl encryptionOptions) {
            this.encryptionOptions = encryptionOptions != null ? encryptionOptions.build() : null;
        }

        public final String getEngineTypeAsString() {
            return engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getHostInstanceType() {
            return hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        public final LogsSummary.Builder getLogs() {
            return logs != null ? logs.toBuilder() : null;
        }

        @Override
        public final Builder logs(LogsSummary logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(LogsSummary.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        public final WeeklyStartTime.Builder getMaintenanceWindowStartTime() {
            return maintenanceWindowStartTime != null ? maintenanceWindowStartTime.toBuilder() : null;
        }

        @Override
        public final Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final void setMaintenanceWindowStartTime(WeeklyStartTime.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        public final String getPendingEngineVersion() {
            return pendingEngineVersion;
        }

        @Override
        public final Builder pendingEngineVersion(String pendingEngineVersion) {
            this.pendingEngineVersion = pendingEngineVersion;
            return this;
        }

        public final void setPendingEngineVersion(String pendingEngineVersion) {
            this.pendingEngineVersion = pendingEngineVersion;
        }

        public final String getPendingHostInstanceType() {
            return pendingHostInstanceType;
        }

        @Override
        public final Builder pendingHostInstanceType(String pendingHostInstanceType) {
            this.pendingHostInstanceType = pendingHostInstanceType;
            return this;
        }

        public final void setPendingHostInstanceType(String pendingHostInstanceType) {
            this.pendingHostInstanceType = pendingHostInstanceType;
        }

        public final Collection<String> getPendingSecurityGroups() {
            return pendingSecurityGroups;
        }

        @Override
        public final Builder pendingSecurityGroups(Collection<String> pendingSecurityGroups) {
            this.pendingSecurityGroups = ___listOf__stringCopier.copy(pendingSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingSecurityGroups(String... pendingSecurityGroups) {
            pendingSecurityGroups(Arrays.asList(pendingSecurityGroups));
            return this;
        }

        public final void setPendingSecurityGroups(Collection<String> pendingSecurityGroups) {
            this.pendingSecurityGroups = ___listOf__stringCopier.copy(pendingSecurityGroups);
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        public final String getStorageTypeAsString() {
            return storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(BrokerStorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final Collection<UserSummary.Builder> getUsers() {
            return users != null ? users.stream().map(UserSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<UserSummary> users) {
            this.users = ___listOfUserSummaryCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserSummary... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserSummary.Builder>... users) {
            users(Stream.of(users).map(c -> UserSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUsers(Collection<UserSummary.BuilderImpl> users) {
            this.users = ___listOfUserSummaryCopier.copyFromBuilder(users);
        }

        @Override
        public DescribeBrokerResponse build() {
            return new DescribeBrokerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
