/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Broker configuration information
 */
@Generated("software.amazon.awssdk:codegen")
public final class Configurations implements SdkPojo, Serializable, ToCopyableBuilder<Configurations.Builder, Configurations> {
    private static final SdkField<ConfigurationId> CURRENT_FIELD = SdkField.<ConfigurationId> builder(MarshallingType.SDK_POJO)
            .getter(getter(Configurations::current)).setter(setter(Builder::current)).constructor(ConfigurationId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("current").build()).build();

    private static final SdkField<List<ConfigurationId>> HISTORY_FIELD = SdkField
            .<List<ConfigurationId>> builder(MarshallingType.LIST)
            .getter(getter(Configurations::history))
            .setter(setter(Builder::history))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("history").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationId> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConfigurationId> PENDING_FIELD = SdkField.<ConfigurationId> builder(MarshallingType.SDK_POJO)
            .getter(getter(Configurations::pending)).setter(setter(Builder::pending)).constructor(ConfigurationId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pending").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_FIELD, HISTORY_FIELD,
            PENDING_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConfigurationId current;

    private final List<ConfigurationId> history;

    private final ConfigurationId pending;

    private Configurations(BuilderImpl builder) {
        this.current = builder.current;
        this.history = builder.history;
        this.pending = builder.pending;
    }

    /**
     * The current configuration of the broker.
     * 
     * @return The current configuration of the broker.
     */
    public ConfigurationId current() {
        return current;
    }

    /**
     * Returns true if the History property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHistory() {
        return history != null && !(history instanceof SdkAutoConstructList);
    }

    /**
     * The history of configurations applied to the broker.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHistory()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The history of configurations applied to the broker.
     */
    public List<ConfigurationId> history() {
        return history;
    }

    /**
     * The pending configuration of the broker.
     * 
     * @return The pending configuration of the broker.
     */
    public ConfigurationId pending() {
        return pending;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(current());
        hashCode = 31 * hashCode + Objects.hashCode(history());
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configurations)) {
            return false;
        }
        Configurations other = (Configurations) obj;
        return Objects.equals(current(), other.current()) && Objects.equals(history(), other.history())
                && Objects.equals(pending(), other.pending());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Configurations").add("Current", current()).add("History", history()).add("Pending", pending())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Current":
            return Optional.ofNullable(clazz.cast(current()));
        case "History":
            return Optional.ofNullable(clazz.cast(history()));
        case "Pending":
            return Optional.ofNullable(clazz.cast(pending()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configurations, T> g) {
        return obj -> g.apply((Configurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Configurations> {
        /**
         * The current configuration of the broker.
         * 
         * @param current
         *        The current configuration of the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder current(ConfigurationId current);

        /**
         * The current configuration of the broker. This is a convenience that creates an instance of the
         * {@link ConfigurationId.Builder} avoiding the need to create one manually via
         * {@link ConfigurationId#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationId.Builder#build()} is called immediately and its
         * result is passed to {@link #current(ConfigurationId)}.
         * 
         * @param current
         *        a consumer that will call methods on {@link ConfigurationId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #current(ConfigurationId)
         */
        default Builder current(Consumer<ConfigurationId.Builder> current) {
            return current(ConfigurationId.builder().applyMutation(current).build());
        }

        /**
         * The history of configurations applied to the broker.
         * 
         * @param history
         *        The history of configurations applied to the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder history(Collection<ConfigurationId> history);

        /**
         * The history of configurations applied to the broker.
         * 
         * @param history
         *        The history of configurations applied to the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder history(ConfigurationId... history);

        /**
         * The history of configurations applied to the broker. This is a convenience that creates an instance of the
         * {@link List<ConfigurationId>.Builder} avoiding the need to create one manually via {@link List
         * <ConfigurationId>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigurationId>.Builder#build()} is called immediately and
         * its result is passed to {@link #history(List<ConfigurationId>)}.
         * 
         * @param history
         *        a consumer that will call methods on {@link List<ConfigurationId>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #history(List<ConfigurationId>)
         */
        Builder history(Consumer<ConfigurationId.Builder>... history);

        /**
         * The pending configuration of the broker.
         * 
         * @param pending
         *        The pending configuration of the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(ConfigurationId pending);

        /**
         * The pending configuration of the broker. This is a convenience that creates an instance of the
         * {@link ConfigurationId.Builder} avoiding the need to create one manually via
         * {@link ConfigurationId#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationId.Builder#build()} is called immediately and its
         * result is passed to {@link #pending(ConfigurationId)}.
         * 
         * @param pending
         *        a consumer that will call methods on {@link ConfigurationId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pending(ConfigurationId)
         */
        default Builder pending(Consumer<ConfigurationId.Builder> pending) {
            return pending(ConfigurationId.builder().applyMutation(pending).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConfigurationId current;

        private List<ConfigurationId> history = DefaultSdkAutoConstructList.getInstance();

        private ConfigurationId pending;

        private BuilderImpl() {
        }

        private BuilderImpl(Configurations model) {
            current(model.current);
            history(model.history);
            pending(model.pending);
        }

        public final ConfigurationId.Builder getCurrent() {
            return current != null ? current.toBuilder() : null;
        }

        @Override
        public final Builder current(ConfigurationId current) {
            this.current = current;
            return this;
        }

        public final void setCurrent(ConfigurationId.BuilderImpl current) {
            this.current = current != null ? current.build() : null;
        }

        public final Collection<ConfigurationId.Builder> getHistory() {
            return history != null ? history.stream().map(ConfigurationId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder history(Collection<ConfigurationId> history) {
            this.history = ___listOfConfigurationIdCopier.copy(history);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(ConfigurationId... history) {
            history(Arrays.asList(history));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder history(Consumer<ConfigurationId.Builder>... history) {
            history(Stream.of(history).map(c -> ConfigurationId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHistory(Collection<ConfigurationId.BuilderImpl> history) {
            this.history = ___listOfConfigurationIdCopier.copyFromBuilder(history);
        }

        public final ConfigurationId.Builder getPending() {
            return pending != null ? pending.toBuilder() : null;
        }

        @Override
        public final Builder pending(ConfigurationId pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(ConfigurationId.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        @Override
        public Configurations build() {
            return new Configurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
