/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.mq.model.CreateBrokerRequest;
import software.amazon.awssdk.services.mq.model.CreateBrokerResponse;
import software.amazon.awssdk.services.mq.model.CreateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.CreateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.CreateTagsRequest;
import software.amazon.awssdk.services.mq.model.CreateTagsResponse;
import software.amazon.awssdk.services.mq.model.CreateUserRequest;
import software.amazon.awssdk.services.mq.model.CreateUserResponse;
import software.amazon.awssdk.services.mq.model.DeleteBrokerRequest;
import software.amazon.awssdk.services.mq.model.DeleteBrokerResponse;
import software.amazon.awssdk.services.mq.model.DeleteTagsRequest;
import software.amazon.awssdk.services.mq.model.DeleteTagsResponse;
import software.amazon.awssdk.services.mq.model.DeleteUserRequest;
import software.amazon.awssdk.services.mq.model.DeleteUserResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerEngineTypesRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerEngineTypesResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerInstanceOptionsRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerInstanceOptionsResponse;
import software.amazon.awssdk.services.mq.model.DescribeBrokerRequest;
import software.amazon.awssdk.services.mq.model.DescribeBrokerResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationResponse;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionRequest;
import software.amazon.awssdk.services.mq.model.DescribeConfigurationRevisionResponse;
import software.amazon.awssdk.services.mq.model.DescribeUserRequest;
import software.amazon.awssdk.services.mq.model.DescribeUserResponse;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;
import software.amazon.awssdk.services.mq.model.ListBrokersResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationRevisionsResponse;
import software.amazon.awssdk.services.mq.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.mq.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.mq.model.ListTagsRequest;
import software.amazon.awssdk.services.mq.model.ListTagsResponse;
import software.amazon.awssdk.services.mq.model.ListUsersRequest;
import software.amazon.awssdk.services.mq.model.ListUsersResponse;
import software.amazon.awssdk.services.mq.model.RebootBrokerRequest;
import software.amazon.awssdk.services.mq.model.RebootBrokerResponse;
import software.amazon.awssdk.services.mq.model.UpdateBrokerRequest;
import software.amazon.awssdk.services.mq.model.UpdateBrokerResponse;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.mq.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.mq.model.UpdateUserRequest;
import software.amazon.awssdk.services.mq.model.UpdateUserResponse;

/**
 * Service client for accessing AmazonMQ asynchronously. This can be created using the static {@link #builder()} method.
 *
 * Amazon MQ is a managed message broker service for Apache ActiveMQ that makes it easy to set up and operate message
 * brokers in the cloud. A message broker allows software applications and components to communicate using various
 * programming languages, operating systems, and formal messaging protocols.
 */
@Generated("software.amazon.awssdk:codegen")
public interface MqAsyncClient extends SdkClient {
    String SERVICE_NAME = "mq";

    /**
     * Create a {@link MqAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MqAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MqAsyncClient}.
     */
    static MqAsyncClientBuilder builder() {
        return new DefaultMqAsyncClientBuilder();
    }

    /**
     * Creates a broker. Note: This API is asynchronous.
     *
     * @param createBrokerRequest
     *        Creates a broker using the specified properties.
     * @return A Java Future containing the result of the CreateBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. This broker name already exists. Retry your request
     *         with another name.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.CreateBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBrokerResponse> createBroker(CreateBrokerRequest createBrokerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a broker. Note: This API is asynchronous.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBrokerRequest#builder()}
     * </p>
     *
     * @param createBrokerRequest
     *        A {@link Consumer} that will call methods on {@link CreateBrokerRequest.Builder} to create a request.
     *        Creates a broker using the specified properties.
     * @return A Java Future containing the result of the CreateBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. This broker name already exists. Retry your request
     *         with another name.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.CreateBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBrokerResponse> createBroker(Consumer<CreateBrokerRequest.Builder> createBrokerRequest) {
        return createBroker(CreateBrokerRequest.builder().applyMutation(createBrokerRequest).build());
    }

    /**
     * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the
     * engine type and version).
     *
     * @param createConfigurationRequest
     *        Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration
     *        (the engine type and version).
     * @return A Java Future containing the result of the CreateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. This configuration name already exists. Retry your
     *         request with another configuration name.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your input and then retry your
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.CreateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConfigurationResponse> createConfiguration(
            CreateConfigurationRequest createConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the
     * engine type and version).<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationRequest#builder()}
     * </p>
     *
     * @param createConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationRequest.Builder} to create a
     *        request. Creates a new configuration for the specified configuration name. Amazon MQ uses the default
     *        configuration (the engine type and version).
     * @return A Java Future containing the result of the CreateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. This configuration name already exists. Retry your
     *         request with another configuration name.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your input and then retry your
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.CreateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConfigurationResponse> createConfiguration(
            Consumer<CreateConfigurationRequest.Builder> createConfigurationRequest) {
        return createConfiguration(CreateConfigurationRequest.builder().applyMutation(createConfigurationRequest).build());
    }

    /**
     * Add a tag to a resource.
     *
     * @param createTagsRequest
     *        A map of the key-value pairs for the resource tag.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Add a tag to a resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsRequest.Builder} to create a request. A map
     *        of the key-value pairs for the resource tag.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * Creates an ActiveMQ user.
     *
     * @param createUserRequest
     *        Creates a new ActiveMQ user.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. Retrying your request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates an ActiveMQ user.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     *        Creates a new ActiveMQ user.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. Retrying your request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * Deletes a broker. Note: This API is asynchronous.
     *
     * @param deleteBrokerRequest
     * @return A Java Future containing the result of the DeleteBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DeleteBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBrokerResponse> deleteBroker(DeleteBrokerRequest deleteBrokerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a broker. Note: This API is asynchronous.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBrokerRequest#builder()}
     * </p>
     *
     * @param deleteBrokerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBrokerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DeleteBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBrokerResponse> deleteBroker(Consumer<DeleteBrokerRequest.Builder> deleteBrokerRequest) {
        return deleteBroker(DeleteBrokerRequest.builder().applyMutation(deleteBrokerRequest).build());
    }

    /**
     * Removes a tag from a resource.
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes a tag from a resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * Deletes an ActiveMQ user.
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an ActiveMQ user.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * Returns information about the specified broker.
     *
     * @param describeBrokerRequest
     * @return A Java Future containing the result of the DescribeBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBrokerResponse> describeBroker(DescribeBrokerRequest describeBrokerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about the specified broker.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBrokerRequest#builder()}
     * </p>
     *
     * @param describeBrokerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBrokerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBrokerResponse> describeBroker(Consumer<DescribeBrokerRequest.Builder> describeBrokerRequest) {
        return describeBroker(DescribeBrokerRequest.builder().applyMutation(describeBrokerRequest).build());
    }

    /**
     * Describe available engine types and versions.
     *
     * @param describeBrokerEngineTypesRequest
     * @return A Java Future containing the result of the DescribeBrokerEngineTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeBrokerEngineTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerEngineTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeBrokerEngineTypesResponse> describeBrokerEngineTypes(
            DescribeBrokerEngineTypesRequest describeBrokerEngineTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Describe available engine types and versions.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBrokerEngineTypesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBrokerEngineTypesRequest#builder()}
     * </p>
     *
     * @param describeBrokerEngineTypesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBrokerEngineTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBrokerEngineTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeBrokerEngineTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerEngineTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeBrokerEngineTypesResponse> describeBrokerEngineTypes(
            Consumer<DescribeBrokerEngineTypesRequest.Builder> describeBrokerEngineTypesRequest) {
        return describeBrokerEngineTypes(DescribeBrokerEngineTypesRequest.builder()
                .applyMutation(describeBrokerEngineTypesRequest).build());
    }

    /**
     * Describe available broker instance options.
     *
     * @param describeBrokerInstanceOptionsRequest
     * @return A Java Future containing the result of the DescribeBrokerInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeBrokerInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBrokerInstanceOptionsResponse> describeBrokerInstanceOptions(
            DescribeBrokerInstanceOptionsRequest describeBrokerInstanceOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Describe available broker instance options.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBrokerInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBrokerInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeBrokerInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBrokerInstanceOptionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeBrokerInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeBrokerInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeBrokerInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBrokerInstanceOptionsResponse> describeBrokerInstanceOptions(
            Consumer<DescribeBrokerInstanceOptionsRequest.Builder> describeBrokerInstanceOptionsRequest) {
        return describeBrokerInstanceOptions(DescribeBrokerInstanceOptionsRequest.builder()
                .applyMutation(describeBrokerInstanceOptionsRequest).build());
    }

    /**
     * Returns information about the specified configuration.
     *
     * @param describeConfigurationRequest
     * @return A Java Future containing the result of the DescribeConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationResponse> describeConfiguration(
            DescribeConfigurationRequest describeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about the specified configuration.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigurationRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationResponse> describeConfiguration(
            Consumer<DescribeConfigurationRequest.Builder> describeConfigurationRequest) {
        return describeConfiguration(DescribeConfigurationRequest.builder().applyMutation(describeConfigurationRequest).build());
    }

    /**
     * Returns the specified configuration revision for the specified configuration.
     *
     * @param describeConfigurationRevisionRequest
     * @return A Java Future containing the result of the DescribeConfigurationRevision operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeConfigurationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfigurationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRevisionResponse> describeConfigurationRevision(
            DescribeConfigurationRevisionRequest describeConfigurationRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns the specified configuration revision for the specified configuration.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRevisionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRevisionRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRevisionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConfigurationRevisionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConfigurationRevision operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeConfigurationRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeConfigurationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRevisionResponse> describeConfigurationRevision(
            Consumer<DescribeConfigurationRevisionRequest.Builder> describeConfigurationRevisionRequest) {
        return describeConfigurationRevision(DescribeConfigurationRevisionRequest.builder()
                .applyMutation(describeConfigurationRevisionRequest).build());
    }

    /**
     * Returns information about an ActiveMQ user.
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns information about an ActiveMQ user.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest) {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * Returns a list of all brokers.
     *
     * @param listBrokersRequest
     * @return A Java Future containing the result of the ListBrokers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListBrokers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBrokersResponse> listBrokers(ListBrokersRequest listBrokersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of all brokers.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrokersRequest.Builder} avoiding the need to
     * create one manually via {@link ListBrokersRequest#builder()}
     * </p>
     *
     * @param listBrokersRequest
     *        A {@link Consumer} that will call methods on {@link ListBrokersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBrokers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListBrokers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBrokersResponse> listBrokers(Consumer<ListBrokersRequest.Builder> listBrokersRequest) {
        return listBrokers(ListBrokersRequest.builder().applyMutation(listBrokersRequest).build());
    }

    /**
     * Returns a list of all brokers.
     *
     * @return A Java Future containing the result of the ListBrokers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListBrokers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBrokersResponse> listBrokers() {
        return listBrokers(ListBrokersRequest.builder().build());
    }

    /**
     * Returns a list of all revisions for the specified configuration.
     *
     * @param listConfigurationRevisionsRequest
     * @return A Java Future containing the result of the ListConfigurationRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListConfigurationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurationRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConfigurationRevisionsResponse> listConfigurationRevisions(
            ListConfigurationRevisionsRequest listConfigurationRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of all revisions for the specified configuration.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationRevisionsRequest#builder()}
     * </p>
     *
     * @param listConfigurationRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigurationRevisionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConfigurationRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListConfigurationRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurationRevisions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConfigurationRevisionsResponse> listConfigurationRevisions(
            Consumer<ListConfigurationRevisionsRequest.Builder> listConfigurationRevisionsRequest) {
        return listConfigurationRevisions(ListConfigurationRevisionsRequest.builder()
                .applyMutation(listConfigurationRevisionsRequest).build());
    }

    /**
     * Returns a list of all configurations.
     *
     * @param listConfigurationsRequest
     * @return A Java Future containing the result of the ListConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConfigurationsResponse> listConfigurations(ListConfigurationsRequest listConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of all configurations.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConfigurationsResponse> listConfigurations(
            Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest) {
        return listConfigurations(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     * Returns a list of all configurations.
     *
     * @return A Java Future containing the result of the ListConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConfigurationsResponse> listConfigurations() {
        return listConfigurations(ListConfigurationsRequest.builder().build());
    }

    /**
     * Lists tags for a resource.
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists tags for a resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * Returns a list of all ActiveMQ users.
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Returns a list of all ActiveMQ users.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * Reboots a broker. Note: This API is asynchronous.
     *
     * @param rebootBrokerRequest
     * @return A Java Future containing the result of the RebootBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.RebootBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/RebootBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootBrokerResponse> rebootBroker(RebootBrokerRequest rebootBrokerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Reboots a broker. Note: This API is asynchronous.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link RebootBrokerRequest#builder()}
     * </p>
     *
     * @param rebootBrokerRequest
     *        A {@link Consumer} that will call methods on {@link RebootBrokerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RebootBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.RebootBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/RebootBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootBrokerResponse> rebootBroker(Consumer<RebootBrokerRequest.Builder> rebootBrokerRequest) {
        return rebootBroker(RebootBrokerRequest.builder().applyMutation(rebootBrokerRequest).build());
    }

    /**
     * Adds a pending configuration change to a broker.
     *
     * @param updateBrokerRequest
     *        Updates the broker using the specified properties.
     * @return A Java Future containing the result of the UpdateBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. Concurrent broker update detected. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.UpdateBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBrokerResponse> updateBroker(UpdateBrokerRequest updateBrokerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Adds a pending configuration change to a broker.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBrokerRequest#builder()}
     * </p>
     *
     * @param updateBrokerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBrokerRequest.Builder} to create a request.
     *        Updates the broker using the specified properties.
     * @return A Java Future containing the result of the UpdateBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. Concurrent broker update detected. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.UpdateBroker
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBrokerResponse> updateBroker(Consumer<UpdateBrokerRequest.Builder> updateBrokerRequest) {
        return updateBroker(UpdateBrokerRequest.builder().applyMutation(updateBrokerRequest).build());
    }

    /**
     * Updates the specified configuration.
     *
     * @param updateConfigurationRequest
     *        Updates the specified configuration.
     * @return A Java Future containing the result of the UpdateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. Concurrent update to configuration. Retry to create
     *         a new revision.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your input and then retry your
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.UpdateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationResponse> updateConfiguration(
            UpdateConfigurationRequest updateConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified configuration.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConfigurationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationRequest.Builder} to create a
     *        request. Updates the specified configuration.
     * @return A Java Future containing the result of the UpdateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. Concurrent update to configuration. Retry to create
     *         a new revision.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your input and then retry your
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.UpdateConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationResponse> updateConfiguration(
            Consumer<UpdateConfigurationRequest.Builder> updateConfigurationRequest) {
        return updateConfiguration(UpdateConfigurationRequest.builder().applyMutation(updateConfigurationRequest).build());
    }

    /**
     * Updates the information for an ActiveMQ user.
     *
     * @param updateUserRequest
     *        Updates the information for an ActiveMQ user.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. Retrying your request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the information for an ActiveMQ user.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     *        Updates the information for an ActiveMQ user.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. Retrying your request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MqException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MqAsyncClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mq-2017-11-27/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }
}
