/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mq.model.RebootBrokerRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RebootBrokerRequestModelMarshaller {
    private static final MarshallingInfo<String> BROKERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("broker-id").isBinary(false).build();
    private static final RebootBrokerRequestModelMarshaller INSTANCE = new RebootBrokerRequestModelMarshaller();

    private RebootBrokerRequestModelMarshaller() {
    }

    public static RebootBrokerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RebootBrokerRequest rebootBrokerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)rebootBrokerRequest), (String)"rebootBrokerRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rebootBrokerRequest.brokerId(), BROKERID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

