/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.services.mq.model.DeploymentMode;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.ListOfUserCopier;
import software.amazon.awssdk.services.mq.model.ListOf__stringCopier;
import software.amazon.awssdk.services.mq.model.MQRequest;
import software.amazon.awssdk.services.mq.model.User;
import software.amazon.awssdk.services.mq.model.WeeklyStartTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateBrokerRequest
extends MQRequest
implements ToCopyableBuilder<Builder, CreateBrokerRequest> {
    private final Boolean autoMinorVersionUpgrade;
    private final String brokerName;
    private final ConfigurationId configuration;
    private final String creatorRequestId;
    private final String deploymentMode;
    private final String engineType;
    private final String engineVersion;
    private final String hostInstanceType;
    private final WeeklyStartTime maintenanceWindowStartTime;
    private final Boolean publiclyAccessible;
    private final List<String> securityGroups;
    private final List<String> subnetIds;
    private final List<User> users;

    private CreateBrokerRequest(BuilderImpl builder) {
        super(builder);
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerName = builder.brokerName;
        this.configuration = builder.configuration;
        this.creatorRequestId = builder.creatorRequestId;
        this.deploymentMode = builder.deploymentMode;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroups = builder.securityGroups;
        this.subnetIds = builder.subnetIds;
        this.users = builder.users;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String brokerName() {
        return this.brokerName;
    }

    public ConfigurationId configuration() {
        return this.configuration;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(this.deploymentMode);
    }

    public String deploymentModeString() {
        return this.deploymentMode;
    }

    public EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public String engineTypeString() {
        return this.engineType;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String hostInstanceType() {
        return this.hostInstanceType;
    }

    public WeeklyStartTime maintenanceWindowStartTime() {
        return this.maintenanceWindowStartTime;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<User> users() {
        return this.users;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBrokerRequest)) {
            return false;
        }
        CreateBrokerRequest other = (CreateBrokerRequest)((Object)obj);
        return Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.brokerName(), other.brokerName()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.deploymentModeString(), other.deploymentModeString()) && Objects.equals(this.engineTypeString(), other.engineTypeString()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType()) && Objects.equals(this.maintenanceWindowStartTime(), other.maintenanceWindowStartTime()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.users(), other.users());
    }

    public String toString() {
        return ToString.builder((String)"CreateBrokerRequest").add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("BrokerName", (Object)this.brokerName()).add("Configuration", (Object)this.configuration()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("DeploymentMode", (Object)this.deploymentModeString()).add("EngineType", (Object)this.engineTypeString()).add("EngineVersion", (Object)this.engineVersion()).add("HostInstanceType", (Object)this.hostInstanceType()).add("MaintenanceWindowStartTime", (Object)this.maintenanceWindowStartTime()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecurityGroups", this.securityGroups()).add("SubnetIds", this.subnetIds()).add("Users", this.users()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoMinorVersionUpgrade": {
                return Optional.of(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "BrokerName": {
                return Optional.of(clazz.cast(this.brokerName()));
            }
            case "Configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
            case "CreatorRequestId": {
                return Optional.of(clazz.cast(this.creatorRequestId()));
            }
            case "DeploymentMode": {
                return Optional.of(clazz.cast(this.deploymentModeString()));
            }
            case "EngineType": {
                return Optional.of(clazz.cast(this.engineTypeString()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "HostInstanceType": {
                return Optional.of(clazz.cast(this.hostInstanceType()));
            }
            case "MaintenanceWindowStartTime": {
                return Optional.of(clazz.cast(this.maintenanceWindowStartTime()));
            }
            case "PubliclyAccessible": {
                return Optional.of(clazz.cast(this.publiclyAccessible()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "Users": {
                return Optional.of(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MQRequest.BuilderImpl
    implements Builder {
        private Boolean autoMinorVersionUpgrade;
        private String brokerName;
        private ConfigurationId configuration;
        private String creatorRequestId;
        private String deploymentMode;
        private String engineType;
        private String engineVersion;
        private String hostInstanceType;
        private WeeklyStartTime maintenanceWindowStartTime;
        private Boolean publiclyAccessible;
        private List<String> securityGroups;
        private List<String> subnetIds;
        private List<User> users;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBrokerRequest model) {
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.brokerName(model.brokerName);
            this.configuration(model.configuration);
            this.creatorRequestId(model.creatorRequestId);
            this.deploymentMode(model.deploymentMode);
            this.engineType(model.engineType);
            this.engineVersion(model.engineVersion);
            this.hostInstanceType(model.hostInstanceType);
            this.maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            this.publiclyAccessible(model.publiclyAccessible);
            this.securityGroups(model.securityGroups);
            this.subnetIds(model.subnetIds);
            this.users(model.users);
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getBrokerName() {
            return this.brokerName;
        }

        @Override
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        public final ConfigurationId.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ConfigurationId configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ConfigurationId.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getDeploymentMode() {
            return this.deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode.toString());
            return this;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType.toString());
            return this;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        public final WeeklyStartTime.Builder getMaintenanceWindowStartTime() {
            return this.maintenanceWindowStartTime != null ? this.maintenanceWindowStartTime.toBuilder() : null;
        }

        @Override
        public final Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final void setMaintenanceWindowStartTime(WeeklyStartTime.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ListOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ListOf__stringCopier.copy(securityGroups);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ListOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ListOf__stringCopier.copy(subnetIds);
        }

        public final Collection<User.Builder> getUsers() {
            return this.users != null ? (Collection)this.users.stream().map(User::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = ListOfUserCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = ListOfUserCopier.copyFromBuilder(users);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateBrokerRequest build() {
            return new CreateBrokerRequest(this);
        }
    }

    public static interface Builder
    extends MQRequest.Builder,
    CopyableBuilder<Builder, CreateBrokerRequest> {
        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder brokerName(String var1);

        public Builder configuration(ConfigurationId var1);

        default public Builder configuration(Consumer<ConfigurationId.Builder> configuration) {
            return this.configuration((ConfigurationId)((ConfigurationId.Builder)ConfigurationId.builder().apply(configuration)).build());
        }

        public Builder creatorRequestId(String var1);

        public Builder deploymentMode(String var1);

        public Builder deploymentMode(DeploymentMode var1);

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder engineVersion(String var1);

        public Builder hostInstanceType(String var1);

        public Builder maintenanceWindowStartTime(WeeklyStartTime var1);

        default public Builder maintenanceWindowStartTime(Consumer<WeeklyStartTime.Builder> maintenanceWindowStartTime) {
            return this.maintenanceWindowStartTime((WeeklyStartTime)((WeeklyStartTime.Builder)WeeklyStartTime.builder().apply(maintenanceWindowStartTime)).build());
        }

        public Builder publiclyAccessible(Boolean var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder users(Collection<User> var1);

        public Builder users(User ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

